% Skript ripple_23.m, in dem der Einfluss der Welligkeit
% eines FIR-Filters untersucht wird

clear;
% -------- Parameter des Systems
fs = 1000;            % Abtastfrequenz
Ts = 1/fs;            % Abtastperiode
% -------- FIR-Filter-Entwurf
fp = 100*2/1000;      % Relative Durchlassfrequenz (MATLAB-Konv.)
fst = 130*2/1000;     % Relative Sperrfrequenz
dp = 1;           % Welligkeit im Durchlassbereich in dB
%dp = 0.1;           % Welligkeit im Durchlassbereich in dB
ds = 80;              % Dmpfung im Sperrbereich
typ = 'equiripple';     
d = fdesign.lowpass('Fp,Fst,Ap,Ast',fp,fst,dp,ds);
hd = design(d,'equiripple');    h = hd.Numerator;
nord = length(h)-1;
[H, w] = freqz(h,1);

figure(1);    clf;
subplot(311);   stem(0:nord, h);
title(['Einheitspulsantwort des FIR-Tiefpassfilters mit Welligkeit = ',...
    num2str(dp),' dB']);
xlabel('n');    grid on;     axis tight;

subplot(312);   plot(0:nord, 20*log10(abs(h)));
title(['Einheitspulsantwort mit logarithmischer Skalierung (dB)']);
xlabel('n');    grid on;     axis tight;

subplot(313);   plot(w/(2*pi), 20*log10(abs(H)));
title('Amplitudengang des FIR-Tiefpassfilters (Ausschnitt)');
xlabel('Relative Frequenz f/fs');   grid on;     
axis([0,0.15,-2*dp, 2*dp]);   ylabel('dB');

% ------- Sprungantwort
sp = filter(h,1,[zeros(1,200), ones(1,500)]);
figure(2);    clf;
subplot(211); plot(0:700-1, sp);

