% Skript ripple_22.m, in dem der Einfluss der Welligkeit
% eines FIR-Filters durch Simulation untersucht wird

clear;
% --------- Simulation des Effekts der Welligkeit in Zeitbereich
% Knstlicher Amplitudengang
nfft = 1000;
%H1 = [0.1*cos(2*pi*(0:fix(nfft*0.4))/30.2)+1,...
%      1.e-3*ones(1,fix(nfft*0.1))];
H1 = [0.25*cos(2*pi*(0:fix(nfft*0.45))/20)+1,...
     1.e-3*ones(1,fix(nfft*0.05))];
H1 = [H1, fliplr(H1(2:end-1))];
neff = length(H1),
% Die entsprechende Einheitspulsantwort
h1 = real(ifft(H1));       h1 = fftshift(h1);
% Die Sprungantwort
sp = filter(h1,1,ones(1,1000));

figure(1);   clf;
subplot(311), plot((0:neff-1)/neff, abs(H1));
title('Knstlich erzeugter Amplitudengang');
xlabel('Relative Frequenz f/fs');         grid on;
subplot(312), plot(0:neff-1, h1);
title('Die Einheitspulsantwort mit linearer Skalierung');
xlabel('Index n');    grid on;
subplot(313), plot(0:length(h1)-1, 20*log10(abs(h1)));
title('Die Einheitspulsantwort mit logarithmischer Skalierung in dB');
xlabel('Index n');    grid on;
La = axis;     axis([La(1:2), -80, 0]);
figure(2);   clf;
subplot(211), plot((0:1000-1), sp);
title('Sprungantwort mit Vor- und Nachecho');
xlabel('Index n');    grid on;

