% Skript ripple_21.m, in dem der Einfluss der Welligkeit
% eines FIR-Filters untersucht wird

clear;
% -------- Parameter des Systems
fs = 1000;            % Abtastfrequenz
Ts = 1/fs;            % Abtastperiode
nbit = 16;            % Anzahl Bits des A/D-Wandlers
% -------- FIR-Filter-Entwurf
fp = 100*2/1000;      % Relative Durchlassfrequenz (MATLAB-Konv.)
fst = 120*2/1000;     % Relative Sperrfrequenz
dp = 0.1;           % Welligkeit im Durchlassbereich in dB
ds = 60;              % Dmpfung im Sperrbereich
%typ = 'equiripple';     
nord = 148;  % Gerade Ordnung
d = fdesign.lowpass('N,Fp,Fst,Ap',nord,fp,fst,dp);
hd = design(d,'equiripple');    h = hd.Numerator;
[H, w] = freqz(h,1);
[Hw,w] = freqz(h,1,'whole');

figure(1);    clf;
subplot(311);   stem(0:nord, h);
title(['Einheitspulsantwort des FIR-Tiefpassfilters mit Welligkeit = ',...
    num2str(dp),' dB']);
xlabel('n');    grid on;     axis tight;
subplot(312);   plot(w*fs/(2*pi), 20*log10(abs(H)));
title('Amplitudengang des FIR-Tiefpassfilters');
xlabel('Hz');   grid on;     axis([0,500,-100, 10]);   ylabel('dB');
subplot(313);   plot(w*fs/(2*pi), 20*log10(abs(H)));
La = axis;      axis([10, 100, -dp*2, dp*2]);
title('Durchlassbereich (Ausschnitt) ');
xlabel('Hz');   grid on;   ylabel('dB');

% -------- Parameter fr die Simulation
hTP = fir1(128, 0.2);   % Tiefpassfilter fr das Eingangssignal
Tsim = 10;
t = [0:Ts:Tsim-Ts];     nt = length(t);
yd = zeros(nt);
options = simset('Solver','FixedStepDiscrete','FixedStep',Ts);
sim('ripple21',[0,Tsim-Ts], options);
yf = var(y.data(nt*0.1:end,3));        % Ohne Einschwingen
yq = var(y1.data(nt*0.1:end,1));        
yd = y.data(:,3);
yeing = y.data(:,2);

figure(2);   clf;
subplot(211),  stem(t(nt*0.1:end),yeing(nt*0.1:end));
title(['Eingangssignal'])
xlabel('Zeit in s');     grid on;        
La =axis;    axis([5, 5.2, La(3:4)]);
subplot(212),  stem(t(nt*0.1:end),yd(nt*0.1:end));
title(['Gesamtfehler'])
xlabel('Zeit in s');     grid on;        
La =axis;    axis([5, 5.2, La(3:4)]);

disp('Mittlere Leistung des Fehlers des Quantisierers = '),yq,
disp('Mittlere Leistung des Gesamtfehlers = '), yf,

