% Skript raised_cosine_3.m, in dem das square Raised-Cosine-Filter,
% untersucht wird

clear;
% ------- Parameter des Filters
fs = 1000;       % Abtastfrequenz
Ts = 1/fs;       % Abtastperiode
ns = 5;          % Anzahl der Abtastwerte in Tsymb
Tsymb = ns*Ts;   % Symbolperiode der digitalen Pulse
alpha = 0.2;     % Roll of Faktor
n_symb = 6;      % Anzahl Perioden Tsymb fr das Filter (gerade Zahl > 2)
% ------- Entwicklung mit MATLAB-Funktion
hrc = rcosdesign(alpha, n_symb, Tsymb/Ts); % Root-Raised-Cosine-Filter
nrc = length(hrc);
hrc1 = conv(hrc, hrc); % Raised-Cosine-Filter   
nrc1 = length(hrc1);

figure(1);    clf; % ----------------
subplot(211), stem(0:nrc-1, hrc);
title(['Einheitspulsantwort hrc des Root-Raised-Cosine-Filters']);
xlabel('n');     grid on;     axis tight;
subplot(212),stem(0:nrc1-1, hrc1);
title('Einheitspulsantwort mit conv(hrc,hrc) berechnet');
xlabel('n');    grid on;

% ------- Aufruf der Simulation
n_fft = 256;   % Buffer-Gre
Tsim = 5;      % Dauer der Simulation
noise = 0.05;
sim('raised_cosine3',[0, Tsim]);
y1 = y.Data;     % Zeitsignale der Simulation
t = y.time;

figure(2);    clf; % -----------
subplot(211), stairs(t, y1(:,1));
La = axis;    axis([2,2.15, La(3:4)*1.2]);
title('Bipolare Pulse der binren Daten'); 
xlabel('s');    grid on;
subplot(212), stairs(t, y1(:,1))
hold on;   plot(t, y1(:,2));   plot(t,y1(:,2));   hold off;
axis tight;    La = axis;    axis([2,2.15, La(3:4)]);
title('Ausgang des square Raised-Cosine-Filters beim Empfnger'); 
xlabel('s');    grid on;   

% -------- Augendiagramm
nt = length(t);     np = 4;
naugen = fix(nt/(np*ns));
figure(3);    clf; % ----------------
for k = 2:naugen-100
    hold on;
    plot(t(np*ns:2*np*ns),y1(k*np*ns+1:(k+1)*np*ns+1,2),'k');
end;    
hold off;    axis tight;    
title('Augendiagramm');    xlabel('s');    grid on;

% -------- Decodierte Daten
figure(4);    clf;
subplot(211), stairs(t, y1(:,1));
title(['Ausgang des square Raised-Cosine-Filters',...
    ' und des Decoders beim Empfnger']); 
xlabel('s');    grid on;   
hold on;    plot(t, y1(:,2));   hold off;
axis tight;    La = axis;    axis([2,2.15, La(3:4)]);
    

    
    
    
    