% Skript raised_cosine_2.m, in dem das Raised-Cosine-Filter
% untersucht wird, das direkt mit den binren Daten angeregt wird 

clear;
% ------- Parameter des Filters
fs = 1000;       % Abtastfrequenz
Ts = 1/fs;       % Abtastperiode
ns = 5;          % Anzahl der Abtastwerte in Tsymb
Tsymb = ns*Ts;   % Symbolperiode der digitalen Pulse
alpha = 0.3;     % Roll of Faktor
n_symb = 8;      % Anzahl Perioden Tsymb fr Filter
% ------- Entwicklung mit MATLAB-Funktion
hrc = rcosdesign(alpha, n_symb, Tsymb/Ts,'normal');
nrc = length(hrc);
[hrcd, rest] = deconv(hrc,ones(1,ns));  % Einheitspulsantwort fr
n = length(hrcd); % das Filter angeregt mit ns*Ts Pulse (binren Daten)
hrcd = hrcd/sum(hrcd);
hrc1 = conv(hrcd, ones(1,ns));  % Antwort auf ns Pulse 
nrc1 = length(hrc1);

figure(1);    clf; % ----------------
subplot(211), stem(0:n-1, hrcd);
title(['Einheitspulsantwort des Raised-Cosine-Filters',...
    ' fr binre Daten aus ns*Ts Pulsen']);
xlabel('n');     grid on;     axis tight;
subplot(212),stem(0:nrc1-1, hrc1);
title('Antwort auf ein Puls der Dauer Tsym = ns*Ts');
xlabel('n');    grid on;

% ------- Aufruf der Simulation
n_fft = 256;   % Buffer-Gre
k_norm = 1/(fs*sum(hamming(n_fft).^2)); % Normierung wegen 
                    % der Fensterfunktion
Tsim = 5;      % Dauer der Simulation
sim('raised_cosine2',[0, Tsim]);
y1 = y.Data(:,:);     % Zeitsignale der Simulation
y2 = psd_y.Data(:,:,end); % Spektrale Leistungsdichten
t = y.time;

figure(2);    clf; % -----------
subplot(211), stairs(t, y1(:,1));
La = axis;    axis([2,2.15, La(3:4)*1.2]);
title('Bipolare binre Daten'); 
xlabel('s');    grid on;
subplot(212), stairs(t, y1(:,1))
hold on; plot(t, y1(:,2));   hold off;
La = axis;    axis([2,2.15, La(3:4)]);
title('Daten als ns*Ts Pulse und Ausgang des Raised-Cosine-Filters'); 
xlabel('s');    grid on;

% -------- Augendiagramm
nt = length(t);     np = 4;
naugen = fix(nt/(np*ns));
figure(3);    clf; % ----------------
for k = 1:naugen-100
    hold on;
    plot(t(np*ns:2*np*ns),y1(k*np*ns+1:(k+1)*np*ns+1,2),'k');
end;    
hold off;    axis tight;    
title('Augendiagramm');    xlabel('s');    grid on;

% -------- Spektren aus psd_y
figure(4);    clf; % ----------------
plot((-n_fft/2:n_fft/2-1)*fs/n_fft, 10*log10(fftshift(y2(:,1))),'k');
hold on;  
plot((-n_fft/2:n_fft/2-1)*fs/n_fft, 10*log10(fftshift(y2(:,2))),'k');
hold off;
title('Spektrale Leistungsdichte ohne und mit Raised-Cosine-Filter'); 
xlabel('Hz');    ylabel('dBW/Hz');    grid on;


    
    
    
    
    