% Skript raised_cosine_1.m, in dem das Raised-Cosine-Filter,
% untersucht wird

clear;
% ------- Parameter des Filters
fs = 1000;       % Abtastfrequenz
Ts = 1/fs;       % Abtastperiode
ns = 5;          % Anzahl Abtastwerte in Tsymb
Tsymb = ns*Ts;   % Symbolrate der digitalen Pulse
alpha = 0.3;  % Roll of Faktor
% ------- Einheitspulsantwort
n_symb = 4;      % 8 Tsymb Bereich fr das Filter
n = -n_symb*ns:n_symb*ns;
hrc = sinc(n*Ts/Tsymb).*(cos(pi*alpha*n*Ts/Tsymb)./...
    (1-4*(alpha*n*Ts/Tsymb).^2+eps));
hrc = hrc/sum(hrc);   % Um den Durchlassbereich eins zu erhalten
nfft = 512;
Hrc = fft(hrc, nfft);
figure(1);    clf; % -----------------
subplot(211), stem(n, hrc);
title(['Einheitspulsantwort des Raised-Cosine-Filters',...
      ' alpha = ',num2str(alpha)]);
xlabel('n');     grid on;
subplot(212), plot((-nfft/2:nfft/2-1)/nfft, fftshift(abs(Hrc)));
title('Amplitudengang des Raised-Cosine-Filters (linear skaliert)');
xlabel('f/fs');    grid on;
% ------- Entwicklung mit MATLAB-Funktion
hrc1 = rcosdesign(alpha, 2*n_symb, Tsymb/Ts,'normal');
hrc1 = hrc1/sum(hrc1); % Um den Durchlassbereich eins zu erhalten
Hrc1 = fft(hrc1, nfft);
figure(2);    clf; % -----------------
subplot(211), stem(n, hrc1);
title('Einheitspulsantwort des RC-Filters mit rcosdesign ermittelt');
xlabel('n');     grid on;
subplot(212), plot((-nfft/2:nfft/2-1)/nfft, fftshift(abs(Hrc1)));
title(['Amplitudengang des Raised-Cosine-Filters'...
    ' (linear skaliert)']);
xlabel('f/fs');    grid on;

% ------- Aufruf der Simulation
n_fft = 256;   % Buffer-Gre
k_norm = 1/(fs*sum(hamming(n_fft).^2)); % Normierung wegen 
                    % der Fensterfunktion
Tsim = 5;      % Dauer der Simulation
sim('raised_cosine1',[0, Tsim]);
%sim('raised_cosine11',[0, Tsim]);

y1 = y.Data(:,:);     % Zeitsignale der Simulation
y2 = psd_y.Data(:,:,end); % Spektrale Leistungsdichten
t = y.time;

figure(3);    clf;  % -----------------
subplot(211), stairs(t, y1(:,2));
La = axis;    axis([2,2.15, La(3:4)*1.2]);
title('Bipolare binre Daten'); 
xlabel('s');    grid on;
subplot(212), stairs(t, y1(:,1))
hold on; plot(t, y1(:,3));   hold off;
La = axis;    axis([2,2.15, La(3:4)]);
title('Binre Daten und Ausgang des Raised-Cosine-Filters'); 
xlabel('s');    grid on;

% -------- Augendiagramm
nt = length(t);     np = 4;
naugen = fix(nt/(np*ns));
figure(4);    clf; % -----------------
for k = 1:naugen-100  % Es werden nicht alle Intervalle benutzt
    hold on;
    plot(t(np*ns:2*np*ns),y1(k*np*ns+1:(k+1)*np*ns+1,3),'k');
end;    
title('Augendiagramm');    xlabel('s');   grid on;    
axis tight;    

hold off;    
% -------- Spektren aus psd_y
figure(5);    clf; % -----------------
plot((-n_fft/2:n_fft/2-1)*fs/n_fft, 10*log10(fftshift(y2(:,1))),'k');
hold on;  
plot((-n_fft/2:n_fft/2-1)*fs/n_fft, 10*log10(fftshift(y2(:,2))),'k');
hold off;
title('Spektrale Leistungsdichte ohne und mit Raised-Cosine-Filter'); 
xlabel('Hz');    ylabel('dBW/Hz');    grid on;

% --------- Parseval Theorem
var_zeit_1 = var(y1(:,2)),       % Varianz der binr Daten
var_freq_1 = sum(y2(:,1))*fs/n_fft, % Varianz aus der spektralen
       % Leistungsdichte fr binre Daten
var_zeit_2 = var(y1(:,3)),       % Varianz der binr Daten
var_freq_2 = sum(y2(:,2))*fs/n_fft, % Varianz aus der spektralen
       % Leistungsdichte fr gefilterte Daten

    
    
    
    
    