% Skript linphaseFIR.m, nach G. Scarpa

clear;
% Linear-phase FIR
h=[1 2 3 -2 5 -2 3 2 1]; % type-I (M=8)
 h=[1 2 3 -2 -2 3 2 1]; % type-II (M=7)
% h=[1 2 3 -2 0 2 -3 -2 -1]; %type-III (M=8)
% h=[1 2 3 -2 2 -3 -2 -1]; %type-IV (M=7) 
M=length(h)-1;
nfft = 512;
[H W] = freqz(h,1,nfft); % frequency responce in [0,?)
W4 = [W; W+pi; W+2*pi; W+3*pi]; % span over [0,4?) 
H4 = [H; flipud(conj(H)); H; flipud(conj(H))];
E = exp(-i*W4*M/2);
if h(1) ~= h(M+1),
     E=i*E; % only for type-III and type-IV
end
A4=real(H4./E); % recall: H(ej?) = jA(ej?)e?j?M/2 
Psi4=angle(H4./A4); % recall: H(ej?) = A(ej?)ej?(ej?)

figure(1);    clf;
subplot(211), plot((0:4*nfft-1)/(2*nfft), A4);
hold on;
subplot(211), plot((0:4*nfft-1)/(2*nfft), abs(H4));
hold off;
title('Nullphase-Verstrkung');
xlabel('f/f_s');   grid on;
subplot(212), plot((0:4*nfft-1)/(2*nfft), Psi4);
title('Phase');
xlabel('f/f_s');   grid on;
