% Skript lattice_1.m, in dem eine Lattice-Struktur
% fr ein FIR-Filter untersucht wird

clear;
% ------- FIR-Filter
[b,a] = ellip(6, 0.1, 60, 0.1*2);
%b = fir1(32, 0.4);    a = 1;
[H, w] = freqz(b,a);
figure(1);   clf;
subplot(211), plot(w/(2*pi), 20*log10(abs(H)));
subplot(212), plot(w/(2*pi), angle(H));

% ------- Umwandlung der tf in Lattice-Parameter
[k,v] = tf2latc(b,a);

% ------- Filterung eines Signals
nx = 300;
x = randn(1,nx);
yd = filter(b,a,x);
[f, g] = latcfilt(k,v,x);
figure(2);   clf;
subplot(311), plot(0:nx-1, yd);
subplot(312), plot(0:nx-1, f);
subplot(313), plot(0:nx-1, g);
hold on
%plot(0:nx-1, [zeros(1,32), 1.2*x(1:end-32)]);
plot(0:nx-1, [zeros(1,7), x(1:end-7)]);

