% Skript lattice_1.m, in dem eine Lattice-Struktur
% fr ein IIR-Filter untersucht wird

clear;
% ------- IIR-Filter
nord = 6;
[b,a] = ellip(nord,1,60,0.2*2);
%[b,a] = butter(nord,0.2*2);
%b = [1, -1, 0.5];   a = [1, 0.2, -0.15];
[H, w] = freqz(b,a);
figure(1);   clf;
subplot(211), plot(w/(2*pi), 20*log10(abs(H)));
title('Amplitudengang des IIR-Filters');
xlabel('f/fs');   grid on;   ylabel('dB');
La = axis;   axis([La(1:2), -100, La(4)]);
subplot(212), plot(w/(2*pi), angle(H));
title('Phasengang des IIR-Filters');
xlabel('f/fs');   grid on;   ylabel('Rad');

% ------- Umwandlung der bertragungsfunktion in Lattice-Parameter
[k,v] = tf2latc(b,a);      % Emittlung der Lattice-Parameter
% ------- Filterung eines Signals
nx = 300;
x = randn(1,nx);
randn('seed', 1378);
yd = filter(b,a,x);        % Filterung mit tf
ylatc = latcfilt(k,v,x);   % Filterung mit Lattice-Parameter

figure(2);   clf;
subplot(211), plot(0:nx-1, yd);
title('Ausgang des IIR-Filters ber die bertragungsfunktion')
xlabel('n');   grid on;
subplot(212), plot(0:nx-1, ylatc);
title('Ausgang des IIR-Filters ber die Lattice-Parameter')
xlabel('n');   grid on;

