% Skript hilbert_filter_2.m, in dem ein Hilbert-Filter
% untersucht wird. Arbeitet mit Modell hilbert_filter1.slx

clear;
% -------- Parameter des Systems
fs = 1000;     Ts = 1/fs;   % Abtastfrequenz und Periode
% -------- Entwicklung des Hilbert-Filters
nord = 64;           % Gerade Ordnung
Tw = 0.1;            % 'Transition' Band
d = fdesign.hilbert(nord, Tw);
hd = design(d, 'equiripple');       
nfft = 512;
[Hd, w] = freqz(hd.numerator, 1, nfft);
h1 = firls(31, [0 0.5]*2, [1,0]);

figure(1);    clf;
subplot(121), stem(0:nord, hd.numerator);
title('Einheitspulsantwort des Hilbert-Filters'); xlabel('n');
grid on;   axis tight;
subplot(222), plot((0:nfft-1)/(2*nfft), 20*log10(abs(Hd)));
title('Amplitudengang des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');     grid on;
phase = unwrap(angle(Hd)) + ((0:nfft-1)*nord*pi/(2*nfft))';
subplot(224), plot((0:nfft-1)/(2*nfft), phase);
title('Phasengang ohne den linearen Teil');
xlabel('Relative Frequenz f/fs');     grid on;
La = axis;    axis([La(1:2), -2, 0]);

% ------ Aufruf der Simulation
Tsim = 10;        % Simulationsdauer
delta = nord/2;       % Versptung fr die Ausrichtung der Signale
k = 1;           % Zwei Eingangssignale
sim('komplexe_huelle1', [0, Tsim]);    % Simulationsaufruf
t = y.time;
y1 = y.Data(:,1);    % Versptetes Signal
y2 = y.Data(:,2);    % Ausgang des Hilbert-Filters

% -------- Spektrum des analytischen Signals
ys = y.Data(nord*10:end,:);     % Daten ohne Einschwingen
nfft = 256;
Yanal = pwelch((ys(:,1)+j*ys(:,2)), hamming(nfft),50,nfft,fs);
Y1 = pwelch((ys(:,1)+j*eps), hamming(nfft),50,nfft,fs);       
Y2 = pwelch((ys(:,2)+j*eps), hamming(nfft),50,nfft,fs);

figure(2);    clf;
subplot(311), plot((-nfft/2:nfft/2-1)/nfft, fftshift(Y1));
title('Spektrale Leistungsdichte des verspteten Signals');
xlabel('Relative Frequenz f/fs');    grid on;

subplot(312), plot((-nfft/2:nfft/2-1)/nfft, fftshift(Y2));
title('Spektrale Leistungsdichte am Ausgang des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');    grid on;

subplot(313), plot((-nfft/2:nfft/2-1)/nfft,...
                     fftshift(abs(Yanal)));
title('Spektrale Leistungsdichte des analytischen Signals');
xlabel('Relative Frequenz f/fs');    grid on;

figure(3);    clf;
subplot(311), plot((0:nfft-1)/nfft, 10*log10(Y1));
axis tight;  La = axis;    axis([La(1:2), -80, 0.8*La(4)]);
title('Spektrale Leistungsdichte des verspteten Signals');
xlabel('Relative Frequenz f/fs');    grid on;

subplot(312), plot((0:nfft-1)/nfft, 10*log10(Y2));
axis tight;  La = axis;    axis([La(1:2), -80, 0.8*La(4)]);
title('Spektrale Leistungsdichte am Ausgang des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');    grid on;

subplot(313), plot((0:nfft-1)/nfft, 10*log10(Yanal));
title('Spektrale Leistungsdichte des analytischen Signals');
xlabel('Relative Frequenz f/fs');    grid on;
axis tight;  La = axis;    axis([La(1:2), -100, 0.8*La(4)]);

figure(4);    clf;
subplot(311), plot((-nfft/2:nfft/2-1)/nfft, 10*log10(fftshift(Y1)));
axis tight;  La = axis;    axis([La(1:2), -80, 0.8*La(4)]);
title('Spektrale Leistungsdichte des verspteten Signals');
xlabel('Relative Frequenz f/fs');    grid on;

subplot(312), plot((-nfft/2:nfft/2-1)/nfft, 10*log10(fftshift(Y2)));
axis tight;  La = axis;    axis([La(1:2), -80, 0.8*La(4)]);
title('Spektrale Leistungsdichte am Ausgang des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');    grid on;

subplot(313), plot((-nfft/2:nfft/2-1)/nfft,...
                     10*log10(fftshift(abs(Yanal))));
title('Spektrale Leistungsdichte des analytischen Signals');
xlabel('Relative Frequenz f/fs');    grid on;
axis tight;  La = axis;    axis([La(1:2), -100, 0.8*La(4)]);


std(y1)^2,
sum(Y1)*fs/256,
sum(Y2)*fs/256,
sum(Yanal)*fs/256,
