% Skript ideale_filter_4.m, in dem die Annherung
% des idealen BS-Filters als FIR-Filter 
% untersucht wird

clear;
% ------- Parameter
fs = 1000;    Ts = 1/fs;  % Abtastfrequenz und Abtastperiode
fs1 = 100;     fs2 = 200;  % Sperrfrequenzen
N = 64;       % Ordnung des Filters;(N+1 Koeffizienten)
% ------- Die Begrenzte Einheitspulsantwort
n = -N/2:N/2;
hid = sin(2*pi*fs1*n*Ts)./(pi*n) - sin(2*pi*fs2*n*Ts)./(pi*n);
hid(N/2+1) = 1-2*(fs2-fs1)*Ts;
figure(1);   clf;
subplot(121), stem(n, hid);
title(['Einheitspulsantwort des BS-FIR-Filters N = ',...
    num2str(N)]);    xlabel('n');   grid on;
% ------- Frequenzgang mit freqz
nfft = 512;     % nfft muss viel grer als N sein
[H,w] = freqz(hid,1,nfft);
subplot(222), plot(w/(2*pi), abs(H));
title('Amplitudengang des Filters');
xlabel('f/fs');     grid on;
subplot(224), plot(w/(2*pi), unwrap(angle(H)));
title('Phasengang des Filters');
xlabel('f/fs');     grid on;
% ------- Das gleiche Filter mit fir1 entwickelt
h = fir1(N, [fs1, fs2]*2/fs, 'stop', hamming(N+1));  % fir1 Funktion 
figure(2);   clf;
subplot(121), stem(n, h);
title(['Einheitspulsantwort ber fir1 N = ',...
    num2str(N)]);    xlabel('n');   grid on;
% ------- Frequenzgang mit freqz
nfft = 512;     % nfft muss viel grer als N sein
[Hn,w] = freqz(h,1,nfft);
subplot(222), plot(w/(2*pi), abs(Hn));
title('Amplitudengang des Filters');
xlabel('f/fs');     grid on;
subplot(224), plot(w/(2*pi), unwrap(angle(Hn)));
title('Phasengang des Filters');
xlabel('f/fs');     grid on;

% -------- Darstellung der Amplitudengnge in dB
figure(3);    clf;
plot(w/(2*pi),20*log10(abs(H)), w/(2*pi), 20*log10(abs(Hn)),'k');
title('Amplitudengang des FIR-Filters ohne und mit Fenster-Funktion');
xlabel('f/fs');     ylabel('dB');    grid on;
La = axis;    axis([La(1:2), -80, 10]);
