% Skript ideale_filter_1.m, in dem die Annherung
% des idealen TP und HP-Filters als FIR-Filter 
% untersucht wird

clear;
% ------- Parameter der Filter
fs = 1000;      % Abtastfrequenz
Ts = 1/fs;      % Abtastperiode
fp_r = 1/5;     % Relative Frequenz zur fs
fp_rm = 2*fp_r; % Relativ zur fs/2
n_m = 17;       % Ausdehnung der sinc-Funktion 2*n_m+1

% ------- Ideale begrenzte Einheitspulsantwort TP
n = -n_m:n_m;          % ungerade Zahl
n_huelle = -n_m:n_m/100:n_m;   % Index fr die Hlle der sinc-Funktion
h_idTP = fp_rm*sinc(n*fp_rm);  % Ideale Begrenzte Einheitspulsantwort
h_idTP_h = fp_rm*sinc(n_huelle*fp_rm);

figure(1);    clf;
subplot(211), stem(n, h_idTP);
hold on;  plot(n_huelle, h_idTP_h, 'r');
title('Begrenzte Einheitspulsantwort des TP');
xlabel('Indizes n');    grid on;

% ------- DTFT numerisch angenhert
df = fs/200;
f = -fs:df:fs;      nf = length(f);
H_TP = zeros(1,nf);
for k = 1:nf
    H_TP(k) = sum(h_idTP.*exp(-j*2*pi*f(k)*n*Ts));
end;

subplot(212), plot(f, abs(H_TP));
title(['DTFT der begrenzten Einheitspulsantwort des TP-Filters ',...
    'fs = ', num2str(fs),' Hz']);
xlabel('Hz');     grid on;

% ------- Ideale begrenzte Einheitspulsantwort HP
n = -n_m:n_m;          % ungerade Zahl
h_idHP = -fp_rm*sinc(n*fp_rm);
p = find(h_idTP == max(h_idTP)); % Index des Maximalwertes
h_idHP(p) = 1 - h_idTP(p);

figure(2);    clf;
subplot(211), stem(n, h_idHP);
hold on;  plot(n_huelle, -h_idTP_h, 'r');
title('Begrenzte Einheitspulsantwort des HP');
xlabel('Indizes n');    grid on;

% ------- DTFT numerisch angenhert
df = fs/200;
f = -fs:df:fs;      nf = length(f);
H_TP = zeros(1,nf);
for k = 1:nf
    H_HP(k) = sum(h_idHP.*exp(-j*2*pi*f(k)*n*Ts));
end;

subplot(212), plot(f, abs(H_HP));
title(['DTFT der begrenzten Einheitspulsantwort des HP-Filters ',...
    'fs = ', num2str(fs),' Hz']);
xlabel('Hz');     grid on;






