% Skript hilbert_filter_3.m, in dem ein Hilbert-Filter
% untersucht wird. Arbeitet mit Modell hilbert_filter2.slx

clear;
% -------- Parameter des Systems
fs = 1000;     Ts = 1/fs;   % Abtastfrequenz und Periode
f0 = 10000;   % Trgerfrequenz
f1 = 100;     % Untere Grenze des Basisbands
f2 = 400;     % Obere Grenze des Basisbands 
% -------- Entwicklung des Hilbert-Filters
nord = 64;           % Gerade Ordnung
Tw = 0.1;            % 'Transition' Band
d = fdesign.hilbert(nord, Tw);
hd = design(d, 'equiripple');       
nfft = 512;
[Hd, w] = freqz(hd.numerator, 1, nfft);

figure(1);    clf;
subplot(121), stem(0:nord, hd.numerator);
title('Einheitspulsantwort des Filters'); xlabel('n');
grid on;   axis tight;
subplot(222), plot((0:nfft-1)/(2*nfft), 20*log10(abs(Hd)));
title('Amplitudengang des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');     grid on;
phase = unwrap(angle(Hd)) + ((0:nfft-1)*nord*pi/(2*nfft))';
subplot(224), plot((0:nfft-1)/(2*nfft), phase);
title('Phasengang ohne den linearen Teil');
xlabel('Relative Frequenz f/fs');     grid on;
La = axis;    axis([La(1:2), -2, 0]);

% ------ Aufruf der Simulation
Tsim = 1;         % Simulationsdauer
delta = nord/2;       % Versptung fr die Ausrichtung der Signale
sim('hilbert_filter3', [0, Tsim]);    % Simulationsaufruf
t = y.time;
y_1 = y.Data(:,1);    % SSB-Signal
y_2 = y.Data(:,2);    % AM-Signal
y_3 = y1.Data(:,1);   % Demoduliertes SSB-Signal
y_4 = y1.Data(:,2);   % Analoges Eingangssignal

% -------- Spektrum des analytischen Signals
ys = y.Data(nord*10:end,:);     % Daten ohne Einschwingen
nfft = 1024;
Y1 = pwelch((ys(:,1)+j*eps), hamming(nfft),50,nfft,fs*50);       
Y2 = pwelch((ys(:,2)+j*eps), hamming(nfft),50,nfft,fs*50);

figure(2);    clf;
subplot(211), plot((-nfft/2:nfft/2-1)*fs*50/nfft,...
    10*log10(fftshift(Y2)));
axis tight;  La = axis;    axis([La(1:2), -100, 0.8*La(4)]);
title('Spektrale Leistungsdichte des AM-Signals');
xlabel('Frequenz Hz');    grid on;

subplot(212), plot((-nfft/2:nfft/2-1)*fs*50/nfft,...
    10*log10(fftshift(Y1)));
axis tight;  La = axis;    axis([La(1:2), -100, 0.8*La(4)]);
title('Spektrale Leistungsdichte des Einseitenband-Signals');
xlabel('Frequenz Hz');    grid on;

figure(3);    clf;
subplot(211), plot((-nfft/2:nfft/2-1)*fs*50/nfft,...
    10*log10(fftshift(Y2)));
axis tight;  La = axis;    axis([0, 1.5e4, -100, 0.8*La(4)]);
title('Spektrale Leistungsdichte des AM-Signals (Ausschnitt)');
xlabel('Frequenz Hz');    grid on;

subplot(212), plot((-nfft/2:nfft/2-1)*fs*50/nfft,...
    10*log10(fftshift(Y1)));
axis tight;  La = axis;    axis([0, 1.5e4, -100, 0.8*La(4)]);
title('Spektrale Leistungsdichte des Einseitenband-Signals (Ausschnitt)');
xlabel('Frequenz Hz');    grid on;

figure(4);   clf;
subplot(211), plot(t, [y_3, y_4]);
title('Sendesignal und demoduliertes Einseitenband-Signal')
xlabel('s');    grid on;
La = axis;    axis([0.2, 0.3, La(3:4)]);


