% Skript hilbert_filter_1.m, in dem ein Hilbert-Filter
% untersucht wird. Arbeitet mit Modell hilbert_filter1.slx

clear;
% -------- Parameter des Systems
fs = 1000;     Ts = 1/fs;   % Abtastfrequenz und Periode
% -------- Entwicklung des Hilbert-Filters
nord = 64;           % Gerade Ordnung
Tw = 0.2;            % 'Transition' Band
d = fdesign.hilbert(nord, Tw);
hd = design(d, 'equiripple');       
nfft = 512;
[Hd, w] = freqz(hd.numerator, 1, nfft);

figure(1);    clf;
subplot(121), stem(0:nord, hd.numerator);
title('Einheitspulsantwort des Filters'); xlabel('n');
grid on;   axis tight;
subplot(222), plot((0:nfft-1)/(2*nfft), 20*log10(abs(Hd)));
title('Amplitudengang des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');     grid on;
phase = unwrap(angle(Hd)) + ((0:nfft-1)*nord*pi/(2*nfft))';
subplot(224), plot((0:nfft-1)/(2*nfft), phase);
title('Phasengang ohne den linearen Teil');
xlabel('Relative Frequenz f/fs');     grid on;
La = axis;    axis([La(1:2), -2, 0]);

% ------ Aufruf der Simulation
Tsim = 2;        % Simulationsdauer
delta = nord/2;       % Versptung fr die Ausrichtung der Signale
k = 0;           % Nur ein Eingangssignal
sim('hilbert_filter1', [0, Tsim]);    % Simulationsaufruf
t = y.time;
y1 = y.Data(:,1);    % Versptetes Signal
y2 = y.Data(:,2);    % Ausgang des Hilbert-Filters

figure(2);   clf;
stairs(t, y.Data);
La = axis;    axis([0.3, 0.35, -1.2, 1.2]);
title('Ausgang des Hilbert-Filters mit nur einem Eingangssignal');
xlabel('Zeit in s');   grid on;

% ------ Aufruf der Simulation
Tsim = 5;        % Simulationsdauer
delta = nord/2;       % Versptung fr die Ausrichtung der Signale
k = 1;           % Zwei Eingangssignale
sim('hilbert_filter1', [0, Tsim]);    % Simulationsaufruf
t = y.time;
y1 = y.Data(:,1);    % Versptetes Signal
y2 = y.Data(:,2);    % Ausgang des Hilbert-Filters

% -------- Spektrum des analytischen Signals
ys = y.Data(nord*10:end,:);     % Daten ohne Einschwingen
ns = length(ys(:,1));
Yanal = fft(ys(:,1)+j*ys(:,2))/ns;
Y1 = fft(ys(:,1))/ns;      Y2 = fft(ys(:,2))/ns;
figure(3);    clf;
subplot(311), plot((0:ns-1)/ns, 20*log10(abs(Y1)));
La = axis;    axis([La(1:2), -100, La(4)]);
title('Amplitudenspektrum des verspteten Signals');
xlabel('Relative Frequenz f/fs');    grid on;
subplot(312), plot((0:ns-1)/ns, 20*log10(abs(Y2)));
La = axis;    axis([La(1:2), -100, La(4)]);
title('Amplitudenspektrum des Ausgangs des Hilbert-Filters');
xlabel('Relative Frequenz f/fs');    grid on;
subplot(313), plot((0:ns-1)/ns, 20*log10(abs(Yanal)));
title('Amplitudenspektrum des analytischen Signals');
xlabel('Relative Frequenz f/fs');    grid on;
La = axis;    axis([La(1:2), -100, La(4)]);







