% Skript fir_pm_3.m, in dem die Funktion firpm
% fr die Entwicklung von Bandpassfiltern
% untersucht wird;
% Die Argumente werden mit der Funktion firpmord

clear;
% -------- Parameter des Filters
dp = 0.1;     % Welligkeit im Durchlassbereich in dB
dpabs = 10^(dp/20)-1;   % Absolute Welligkeit
ds = 60;      % Dmpfung im Sperrbereich
dsabs = 10^(-ds/20);
fp = 0.1;     % Relative Durchlassfrequenz (fp/fs)
fp1 = 0.3;
f = [0.95*fp, fp, fp1, 1.02*fp1]*2;  % Relative Eckfrequenzen
%f = [0.95*fp, fp, fp1, 1.05*fp1]*2;  % Relative Eckfrequenzen

a = [0, 1, 0];
dev = [dsabs, dpabs, dsabs]; 
[n, f0, a0, wi] = firpmord(f,a,dev);
% -------- Entwicklung des Filters
h = firpm(n, f0, a0, wi); 
[H, w] = freqz(h,1,1024);

figure(1);    clf;
subplot(311), stem(0:n,h);
title('Einheitspulsantwort');    xlabel('n');     grid on;
La = axis;    axis([0, n+1, La(3:4)]);
subplot(312), plot(w/(2*pi), 20*log10(abs(H)));
La = axis;    axis([La(1:2), -100, 10]);
title('FIR-Filter entwickelt mit firpmord und firpm');
xlabel('f/fs');    ylabel('dB');    grid on;
subplot(313), pz = plot(w/(2*pi), 20*log10(abs(H))); 
La = axis;    axis([La(1:2), -0.3, 0.3]);
title('Ausschnitt fr |H(f)| ');
xlabel('f/fs');    ylabel('dB');    grid on
set(pz.Parent,'YTick',[-0.5:0.1:0.5]);

