% Skript fir_pm_2.m, in dem die Funktion firpm
% fr die Entwicklung von Tiefpassfiltern
% untersucht wird;
% Die Argumente werden mit der Funktion firpmord

clear;
% -------- Parameter des Filters
dp = 0.1;     % Welligkeit im Durchlassbereich in dB
dpabs = 10^(dp/20)-1;   % Absolute Welligkeit
ds = 60;      % Dmpfung im Sperrbereich
dsabs = 10^(-ds/20);
fp = 0.2;     % Relative Durchlassfrequenz (fp/fs)
f = [fp, 1.1*fp]*2;  % Relative Eckfrequenzen
a = [1, 0];
dev = [dpabs, dsabs];
% a = [0, 1];           % Fr Hochpassfilter
% dev = [dsabs, dpabs]; % Fr Hochpassfilter

[n, f0, a0, wi] = firpmord(f,a,dev);
% -------- Entwicklung der Filter
h = firpm(n, f0, a0, wi);     
[H, w] = freqz(h,1);
figure(1);    clf;
subplot(311), stem(0:n,h);
title('Einheitspulsantwort');    xlabel('n');     grid on;
La = axis;    axis([0, n+1, La(3:4)]);
subplot(312), plot(w/(2*pi), 20*log10(abs(H)));
La = axis;    axis([La(1:2), -100, 10]);
title('FIR-Filter entwickelt mit firpmord und firpm');
xlabel('f/fs');    ylabel('dB');    grid on;
subplot(313), pz = plot(w/(2*pi), 20*log10(abs(H))); 
La = axis;    axis([0.1, 0.25, -0.5, 0.5]);
title('Ausschnitt fr |H(f)| ');
xlabel('f/fs');    ylabel('dB');    grid on
set(pz.Parent,'YTick',[-0.5:0.1:0.5]);

