% Skript fir_pm_1.m, in dem die Funktion firpm
% fr die Entwicklung von Tiefpassfiltern
% untersucht wird;

clear;
% -------- Parameter des Filters
fp = 0.2;     % Relative Durchlassfrequenz (fp/fs)
N = 64;       % Ordnung des Filters
f1 = [0, fp, 1.05*fp, 0.5]*2;  % Relative Eckfrequenzen
f2 = [0, fp, 1.2*fp, 0.5]*2;   % Relative Eckfrequenzen
m = [1, 1, 0, 0];

% -------- Entwicklung der Filter
h1 = firpm(N,f1,m);       h2 = firpm(N,f2,m);
[H1, w] = freqz(h1,1);    [H2, w] = freqz(h2,1);

figure(1);    clf;
subplot(221), plot(w/(2*pi), 20*log10(abs(H1)));
La = axis;    axis([La(1:2), -60, 10]);
title('|H(f)| mit kleinerem bergangsbereich');
xlabel('f/fs');    grid on
subplot(222), plot(w/(2*pi), 20*log10(abs(H2))); 
La = axis;    axis([La(1:2), -60, 10]);
title('|H(f)| mit grerem bergangsbereich');
xlabel('f/fs');    grid on

subplot(223); plot(w/(2*pi), 20*log10(abs(H1)));
La = axis;    axis([0, 0.3, -2, 2]);
title('Ausschnitt fr den Amplitudengang');
xlabel('f/fs');    grid on

subplot(224); plot(w/(2*pi), 20*log10(abs(H2)));
La = axis;    axis([0, 0.3, -2, 2]);
title('Ausschnitt fr den Amplitudengang');
xlabel('f/fs');    grid on
