% Skript fir_ls_1.m, in dem ein Bandpassfilter
% mit der Funktion firls entwickelt und untersucht wird.

clear;
% -------- Parameter des Filters
fp = 0.1;     % Relative Durchlassfrequenz (fp/fs)
fp1 = 0.3;
f = [0, 0.95*fp, fp, fp1, 1.02*fp1, 0.5]*2;  % Relative Eckfrequenzen
a = [0, 0, 1, 1, 0, 0];  % Eckwerte fr den Amplitudengang
% -------- Entwicklung des Filters
wi = [10, 1, 10]; % Wichtigkeiten der Bnder
n = 400;       % Ordnung des Filters
h = firls(n, f, a, wi); 
[H, w] = freqz(h,1,1024);

figure(1);    clf;
subplot(311), stem(0:n,h);
title('Einheitspulsantwort');    xlabel('n');     grid on;
La = axis;    axis([0, n+1, La(3:4)]);
subplot(312), plot(w/(2*pi), 20*log10(abs(H)));
La = axis;    axis([La(1:2), -100, 10]);
title('FIR-Filter entwickelt mit firpmord und firpm');
xlabel('f/fs');    ylabel('dB');    grid on;
subplot(313), pz = plot(w/(2*pi), 20*log10(abs(H))); 
La = axis;    axis([La(1:2), -0.3, 0.3]);
title('Ausschnitt fr |H(f)| ');
xlabel('f/fs');    ylabel('dB');    grid on
set(pz.Parent,'YTick',[-0.5:0.1:0.5]);
