% Skript fenster_funktion_1.m, in dem die DTFT
% von Fensterfunktionen untersucht werden

clear;
% -------- Parameter der Fensterfunktion
N = 63;     % Gre der Fensterfunktion (hier ungerade Zahl)
nw = -(N-1)/2:(N-1)/2;      % Index der Fensterfunktion
w1 = ones(N,1);             % Rechteckfenster
w2 = hamming(N);            % Hamming-Fenster
w3 = hann(N);               % Han-Fenster

w = [w1,w2,w3];   % Matrix mit den Fensterfunktionen als Spalten
nfft = 1024;      % Gitter fr die DTFT (nfft >> N)
W = fft(w,nfft);

figure(1);    clf;
subplot(321), stem(nw, w1);
title('Recheckiges Fenster');
xlabel('n');  grid on;
subplot(323), stem(nw, w2);
title('Hamming-Fenster');
xlabel('n');  grid on;
subplot(325), stem(nw, w3);
title('Hann-Fenster');
xlabel('n');  grid on;
subplot(322), plot((-nfft/2:nfft/2-1)/nfft, abs(fftshift(W(:,1))));
La = axis;  axis([-0.1, 0.1, La(3:4)]);
title('DTFT des rechteckigen Fenster');
xlabel('f/fs');   grid on;
subplot(324), plot((-nfft/2:nfft/2-1)/nfft, abs(fftshift(W(:,2))));
La = axis;  axis([-0.1, 0.1, La(3:4)]);
title('DTFT des Hamming-Fensters');
xlabel('f/fs');   grid on;
subplot(326), plot((-nfft/2:nfft/2-1)/nfft, abs(fftshift(W(:,3))));
La = axis;  axis([-0.1, 0.1, La(3:4)]);
title('DTFT des Hann-Fensters');
xlabel('f/fs');   grid on;

figure(2);    clf;
plot((-nfft/2:nfft/2-1)/nfft, 20*log10(fftshift(abs(W(:,1)))),...
     (-nfft/2:nfft/2-1)/nfft, 20*log10(fftshift(abs(W(:,2)))),'k',...
     (-nfft/2:nfft/2-1)/nfft, 20*log10(fftshift(abs(W(:,3)))),'k');
La = axis;  axis([-0.2, 0.2, -80, 50]);
title('DTFT der Fensterfunktionen in dB');
xlabel('f/fs');    grid on;
legend('Rechteckiges','Hamming','Hann');

% ------- berprfung der Ergebnisse mit dem Parseval-Theorem
i = 1;                 % Wahl eines Fensters i = 1,2,3
W(:,2)'*W(:,2)/nfft,   % Leistung aus dem Frequenzbereich
sum(w(:,2).^2),        % Leistung des Fensters aus dem Zeitbereich