% Skript fdesign_3.m, in dem exemplarisch der Einsatz 
% der Funktion fdesign/design mit der Option iirlpnorm
% fr ein Tiefpassfilter gezeigt wird

clear;
% ------- Parameter der Filter
fp = 0.2*2;      % Durchlassfrequenz MATLAB-Konv.
fst = 0.25*2;    % Sperrfrequenz MATLAB-Konv
Nb = 8;          % Grad des Polynoms im Zhler
Na = 6;          % Grad des Polynoms im Nenner
% ------- Entwicklung des FIR- und IIR-Filters
d = fdesign.lowpass('Nb,Na,Fp,Fst',Nb,Na,fp,fst);
designmethods(d),
H_IIR = design(d,'iir','Wpas',1,'Wstop',25);  % IIR-Filter
info(H_IIR),
%###################################
Nb = 8;          % Grad des Polynoms im Zhler
Na = 8;          % Grad des Polynoms im Nenner
% ------- Entwicklung des FIR- und IIR-Filters
d1 = fdesign.lowpass('Nb,Na,Fp,Fst',Nb,Na,fp,fst);
designmethods(d1),
H_IIR1 = design(d1,'iir','Wpas',1,'Wstop',25);  % IIR-Filter
info(H_IIR1),

% ------- Frequenzgnge
nfft = 1024;
[H,w] = freqz(H_IIR);     % Frequenzgang IIR-Filter
[H1,w] = freqz(H_IIR1);   % Frequenzgang IIR-Filter

figure(1);    clf;
subplot(211), plot(w/(2*pi), [20*log10(abs(H)),...
    20*log10(abs(H1))]);
title('Amplitudengang der IIR-Filter');
xlabel('f/fs');   grid on;   ylabel('dB');
La = axis;   axis([La(1:2), -100, 10]);
legend('8-6 IIR','8-8 IIR')
subplot(212), plot(w/(2*pi), [unwrap(angle(H)),...
    unwrap(angle(H1))]);
title('Phasengang der IIR-Filter');
xlabel('f/fs');   grid on;   ylabel('dB');


