% Skript fdesign_2.m, in dem exemplarisch der Einsatz 
% der Funktion fdesign fr ein Tiefpassfilter gezeigt wird

clear;
% ------- Parameter der Filter
fp = 0.2*2;      % Durchlassfrequenz MATLAB-Konv.
fst = 0.22*2;    % Sperrfrequenz MATLAB-Konv
dp = 1;          % Welligkeit in Durchlassbereich
ds = 60;         % Dmpfung im Sperrbereich
% ------- Entwicklung des FIR- und IIR-Filters
d = fdesign.lowpass('Fp,Fst,Ap,Ast',fp, fst, dp, ds);
H_FIR = design(d,'equiripple');  % FIR-Filter
info(H_FIR),
designmethods(d),
H_IIR = design(d,'ellip');       % IIR-Filter
info(H_IIR),
% ------- Frequenzgnge
nfft = 1024;
[H1,w] = freqz(H_FIR);   % Frequenzgang FIR-Filter
[H2,w] = freqz(H_IIR);   % Frequenzgang IIR-Filter
figure(1);    clf;
subplot(211), plot(w/(2*pi), [20*log10(abs(H1)),20*log10(abs(H2))]);
title('Amplitudengang des FIR- und IIR-Filters');
xlabel('f/fs');   grid on;   ylabel('dB');
La = axis;   axis([La(1:2), -100, 10]);

subplot(212), plot(w/(2*pi), [20*log10(abs(H1)),20*log10(abs(H2))]);
title('Ausschnitt: Amplitudengang des FIR- und IIR-Filters');
xlabel('f/fs');   grid on;   ylabel('dB');
La = axis;   axis([0, 0.25, -2, 2]);


