% Skript fdesign_1.m, in dem ein FIR-Bandpassfilter mit den 
% Funktionen der DSP System Tollbox entwickelt wird

clear;
% -------- Parameter des Filters
fs1 = 0.1*2;     % Erste Sperrfrequenz (MATLAB-konv.)
fp1 = 0.11*2;    % Erste Durchlassfrequenz
fp2 = 0.3*2;     % Zweite Durchlassfrequenz
fs2 = 0.31*2;    % Zweite Sperrfrequenz
dp = 0.1;        % Welligkeitabweichung im Durchlassbereich in dB
ds = 60;         % Dmpfung im Sperrbereich
% -------- Spezifizierungsobjekt
d = fdesign.bandpass('Fst1,Fp1,Fp2,Fst2,Ast1,Ap,Ast2',...
    fs1, fp1, fp2, fs2, ds, dp, ds);
% Mgliche Filtertypen
designmethods(d),     % Mgliche Filtertypen (IIR oder FIR)
% Filter Entwurf
Hd = design(d,'equiripple');  % Ermittlung der Einheitspulsantwort
freqz(Hd); % Overloaded Method, die das Filter Visualization Tool
% ffnet (oder mit fvtool(Hd))
hd = Hd.numerator;       nhd = length(hd); % Einheitspulsantwort
[H, w] = freqz(hd,1);
figure(1);      clf;
subplot(121), stem(0:nhd-1, hd);
title('Einheitspulsantwort');  xlabel('n');  
axis tight;   grid on;
subplot(222), plot(w/(2*pi), 20*log10(H));
title('Amplitudengang');    xlabel('f/fs');  grid on;
subplot(224), plot(w/(2*pi), 20*log10(H));
title('Durchlassbereich (Ausschnitt)');    xlabel('f/fs');  grid on;
La = axis;    axis([La(1:2), -0.1, 0.1]);

% -------- Spezifikation mit Ordnung des Filters
nord = 18;
d = fdesign.bandpass('N,Fst1,Fp1,Fp2,Fst2,Ap',...
    nord, fs1, fp1, fp2, fs2, dp);
% Mgliche Filtertypen
designmethods(d),     % Mgliche Filtertypen (IIR oder FIR)
Hd1 = design(d,'ellip');
fvtool(Hd1);







