% Skript abtast_fir_3.m, in dem ein FIR-Multibandpassfilter
% ber die Abtastung des Frequenzgangs entwickelt wird
% Es wird die Funktion fir2 benutzt

clear;
% ------- Parameter
fs = 1000;      Ts = 1/fs;  % Abtastfrequnez, Abtastperiode
fp1 = 100;      fp2 = 200;  % Durchlassband 1
fp3 = 300;      fp4 = 400;  % Durchlassband 2
N = 80;         % Ordnung des Filters (N+1 Filter-Koeffizienten)
% ------- Ideale begrenzte Einheitspulsantwort mit fir2
f = [0, fp1, fp1, fp2, fp2, fp3, fp3, fp4, fp4 fs/2]*2/fs; 
m = [0, 0,   1,   1,   0,   0,   0.1,   0.1,   0,  0];     
% Eckpunkte fr die Frequenz und fr den Amplitudengang
hid = fir2(N, f, m, hamming(N+1));    % Einheitspulsantwort 
nfft = 512;
[H,w] = freqz(hid,1,nfft,'whole');

figure(1);    clf;
subplot(211), plot((0:nfft-1)/nfft, 20*log10(abs(H)));
title('Amplitudengang des Multibandfilters');
xlabel('f/fs');    ylabel('dB');     grid on;
subplot(212), stem(0:N, hid);
title(['Einheitspulsantwort des Filters ber Funktion fir2 ']);
xlabel('n');     grid on;     axis tight;

