% Skript abtast_fir_3.m, in dem ein FIR-Tiefpassfilter
% ber die Abtastung des Frequenzgangs entwickelt wird
% Es wird die Funktion fir2 benutzt

clear;
% ------- Parameter
fs = 1000;      Ts = 1/fs;  % Abtastfrequnez, Abtastperiode
fp = 200;       % Durchlassfrequenz;
N = 64;         % Ordnung des Filters (N+1 Filter-Koeffizienten)
% ------- Ideale begrenzte Einheitspulsantwort mit fir2
f = [0, fp, 1.01*fp, fs/2]*2/fs; % Eckpunkte fr die Frequenz
%f = [0, fp, fp, fs/2]*2/fs;
m = [1, 1, 0, 0];     % Eckpunkte fr den Amplitudengang

hid = fir2(N, f, m, hamming(N+1));    % Einheitspulsantwort 
nfft = 512;
[H,w] = freqz(hid,1,nfft,'whole');

figure(1);    clf;
subplot(211), plot((0:nfft-1)/nfft, 20*log10(abs(H)));
title('Amplitudengang des TP-Filters');
xlabel('f/fs');    ylabel('dB');     grid on;
subplot(212), stem(0:N, hid);
title(['Einheitspulsantwort des TP-Filters ber Funktion fir2 ']);
xlabel('n');     grid on;     axis tight;

