% Skript IIR_filter_3.m, in dem IIR-Tiefpassfilter 
% untersucht werden

clear;
% ------- Parameter der IIR-Tiefpassfilter
fp = 0.2*2;      % Relative zu fs Durchlassfrequenz
fsp = 0.25*2;    % Relative zu fs Sperrfrequenz
dp = 1;        % Welligkeit im Durchlassbereich
ds = 60;       % Dmpfung im Sperrbereich
% ------- Ordnung der Filter
[n_butter, wb] = buttord(fp, fsp, dp, ds);  % Ordnung des Butterworth-Filters
[n_cheb1, wc1] = cheb1ord(fp, fsp, dp, ds); % Ordnung des Chebyschev1-Filters
[n_cheb2, wc2] = cheb2ord(fp, fsp, dp, ds); % Ordnung des Butterworth-Filters
[n_ellip, we]  = ellipord(fp, fsp, dp, ds); % Ordnung des Elliptischen-Filters
% ------- Entwicklung der IIR-Filter
[b,a] = butter(n_butter, wb);
[b1,a1] = cheby1(n_cheb1, dp, wc1);
[b2,a2] = cheby2(n_cheb2, ds, wc2);
[b3,a3] = ellip(n_ellip, dp, ds, we);
% ------- Frequenzgnge
nfft = 1024;
[H,w] = freqz(b,a, nfft);
[H1,w] = freqz(b1,a1, nfft);
[H2,w] = freqz(b2,a2, nfft);
[H3,w] = freqz(b3,a3, nfft);
figure(1);
subplot(221), plot(w/(2*pi), 20*log10(abs(H)));
title(['Butterworth IIR-Filter (nord = ',num2str(n_butter),')']);
xlabel('f/fs');    grid on;
La = axis;    axis([La(1:2), -120, 10]);
subplot(222), plot(w/(2*pi), 20*log10(abs(H1)));
title(['Chebyschev Typ I IIR-Filter (nord = ',num2str(n_cheb1),')']);
xlabel('f/fs');    grid on;
La = axis;    axis([La(1:2), -120, 10]);
subplot(223), plot(w/(2*pi), 20*log10(abs(H2)));
title(['Chebyschev Typ II IIR-Filter (nord = ',num2str(n_cheb2),')']);
xlabel('f/fs');    grid on;
La = axis;    axis([La(1:2), -120, 10]);
subplot(224), plot(w/(2*pi), 20*log10(abs(H3)));
title(['Elliptisches IIR-Filter (nord = ',num2str(n_ellip),')']);
xlabel('f/fs');    grid on;
La = axis;    axis([La(1:2), -120, 10]);
% -------- Gruppenlaufzeit
[grd, w] = grpdelay(b,a,nfft);   % Fr Butterworth-Filter
[grd1, w] = grpdelay(b1,a1,nfft);   % Fr Chebyschev I
[grd2, w] = grpdelay(b2,a2,nfft);   % Fr Chebyschev II
[grd3, w] = grpdelay(b3,a3,nfft);   % Fr Elliptisches Filter

figure(2);    clf;
%plot(w/(2*pi), [grd, grd1, grd2, grd3]);
plot(w/(2*pi),grd,w/(2*pi),grd1,'k',w/(2*pi),...
    grd2,'k',w/(2*pi),grd3,'k');

title(['Gruppenlaufzeiten der IIR-Tiefpassfilter mit fp/fs = ',...
    num2str(fp/2)]);
xlabel('f/fs');   grid on;   ylabel('Gruppenlaufzeit in Abtastwerte')
legend('Butterworth', 'Chebyschev Typ I', 'Chebyschev Typ II', 'Elliptisch');


