% Skript IIR_filter_2.m, in dem ein IIR-Bandpassfilter aus 
% direkt entwickelt wird

clear;
% ------- Parameter des IIR-Bandpassfilters
fp1 = 0.25;    fp2 = 0.3;    % Relative zu fs Durchlassfrequenzen
dp = 1;        % Welligkeit im Durchlassbereich
ds = 60;       % Dmpfung im Sperrbereich
nord = 5;      % Ordnung des Filters
% ------- Entwicklung des IIR-Filters
[z,p,k] = ellip(nord, dp, ds, [fp1, fp2]*2); % Null- polstellen des Filters
[b,a] = zp2tf(z,p,k);      % Koeffizienten der bertragungsfunktion
nfft = 1024;
[H_BP,w] = freqz(b,a,nfft);   % Frequenzgang fr nfft Frequenzwerte
figure(1);    clf;
subplot(211), plot(w/(2*pi), 20*log10(abs(H_BP)));
title('Amplitudengang des Tiefpassfilters');
xlabel('Rad/s');   ylabel('dB');   grid on;
La = axis;     axis([La(1:2), -100, La(4)]);
subplot(212), plot(w/(2*pi), unwrap(angle(H_BP)));
title('Phasengang des Tiefpassfilters');
xlabel('Rad/s');   ylabel('Rad');    grid on;

