% Skript IIR_filter_1.m, in dem ein IIR-Bandpassfilter aus 
% einem analogen prototyp Tiefpassfilter ermittelt wird

clear;
% ------- Parameter des IIR-Bandpassfilters
fp1 = 0.25;    fp2 = 0.3;    % Relative zu fs Durchlassfrequenzen
dp = 1;        % Welligkeit im Durchlassbereich
ds = 60;       % Dmpfung im Sperrbereich
nord = 5;      % Ordnung des Filters
% ------- Entwicklung des prototyp analogen Filters
[z,p,k] = ellipap(nord, dp, ds); % Null- polstellen des Filters
[b,a] = zp2tf(z,p,k);      % Koeffizienten der bertragungsfunktion
n = 500;
[H_LP,w] = freqs(b,a,n);   % Frequenzgang fr n Frequenzwerte
figure(1);    clf;
subplot(221), semilogx(w, 20*log10(abs(H_LP)));
title('Amplitudengang des Tiefpassfilters');
xlabel('Rad/s');   ylabel('dB');   grid on;
subplot(223), semilogx(w, unwrap(angle(H_LP)));
title('Phasengang des Tiefpassfilters');
xlabel('Rad/s');   ylabel('Rad');    grid on;

% ------- Entwicklung des analogen Bandpassfilters
Ts = 1;                     % Fr relative Frequenzen
wkp1 = (2/Ts)*tan(pi*fp1);  % Prewarping der Frequenz fp1
wkp2 = (2/Ts)*tan(pi*fp2);  % Prewarping der Frequenz fp2
w0 = sqrt(wkp1*wkp2);   B = wkp2-wkp1; % Mittefreq. und Bandbreite
[b1,a1] = lp2bp(b,a,w0, B); % Transformation Tiefpass-zu-Tiefpass
n = 1000;
[H_BP,w1] = freqs(b1,a1,n);   % Frequenzgang fr n Frequenzwerte

subplot(222), semilogx(w1, 20*log10(abs(H_BP)));
title('Amplitudengang des Bandpassfilters');
xlabel('Rad/s');   ylabel('dB');   grid on;
subplot(224), semilogx(w1, unwrap(angle(H_BP)));
title('Phasengang des Bandpassfilters');
xlabel('Rad/s');   ylabel('Rad');    grid on;

% ------- Umwandlung in einem zeitdiskreten IIR-Filter
[b2, a2] = bilinear(b1, a1, 1/Ts); % Biliniare Transformation
figure(2);    clf;
subplot(211), plot(w2/(2*pi), 20*log10(abs(H_dBP)));
title('Amplitudengang des IIR-Filters');
xlabel('f/fs');   ylabel('dB');   grid on;
La = axis;     axis([La(1:2), -100, La(4)]);
subplot(212), plot(w2/(2*pi), unwrap(angle(H_dBP)));
title('Phasengang des IIR-Filters');
xlabel('f/fs');   ylabel('Rad');    grid on;




