% Skript FIR_Filter_Typ_2.m, in dem ein FIR-Differentiator
% Typ IV untersucht wird

clear;
% -------- Parameter der Filter
N1 = 33;     n1 = 0:N1;  % Ordnung; Indizes Einheitspulsantwort 
f = [0, 0.5]*2;   % Frequenzbereich (MATLAB-Konvention)
m = [0, pi];      % Eckpunkte des Amplitudengang
b1 = firpm(N1,f,m,'d');
b1 = b1.*hamming(N1+1)';    % Mindert die Welligkeit

figure(1);   clf;
subplot(121), stem(n1, b1);
title(['Einheitspulsantwort (Ordnung N = ',...
    num2str(N1),')']);  xlabel('n');   grid on;    axis tight;
xlabel('n');   grid on;    axis tight;

% ------ Frequenzgang ber freqz
nfft = 512;       % nfft >> N1, N2
[H1, w1] = freqz(b1,1,nfft);

subplot(222), plot(w1/(2*pi), (abs(H1)));
title('Amplitudengang des FIR-Filters Typ IV');
xlabel('f/fs');    grid on;
subplot(224), plot(w1/(2*pi), unwrap(angle(H1)));
title('Phasengang des FIR-Filters Typ IV');
xlabel('f/fs');    grid on;

