% Skript FIR_Filter_Typ_1.m, in dem ein FIR-Hochpassfilter
% Typ I untersucht wird

clear;
% -------- Parameter der Filter
N1 = 64;     n1 = 0:N1;  % Ordnung; Indizes Einheitspulsantwort 
fr = 0.4;                % Relative Frequenz f/(fs/2)
b1 = fir1(N1, fr, 'high',hamming(N1+1)); % Filter Entwurf mit fir1

figure(1);   clf;
subplot(121), stem(n1, b1);
title(['Einheitspulsantwort HP Typ I, Ordnung N = ',...
    num2str(N1)]);  xlabel('n');   grid on;    axis tight;
xlabel('n');   grid on;    axis tight;

% ------ Frequenzgang ber freqz
nfft = 512;       % nfft >> N1, N2
[H1, w1] = freqz(b1,1,nfft);

subplot(222), plot(w1/(2*pi), 20*log10(abs(H1)));
title('Amplitudengang des FIR-Filters Typ I');
xlabel('f/fs');    grid on;
subplot(224), plot(w1/(2*pi), unwrap(angle(H1)));
title('Phasengang des FIR-Filters Typ I');
xlabel('f/fs');    grid on;

