% Skript FIR_Filter_Typ.m, in dem ein FIR-Tiefpassfilter
% Typ I und Typ II untersucht wird

clear;
% -------- Parameter der Filter
N1 = 32;     n1 = 0:N1;  % Ordnung; Indizes Einheitspulsantwort 
fr = 0.2;                % Relative Frequenz f/(fs/2)
b1 = fir1(N1, fr, hamming(N1+1)); % Filter Entwurf mit fir1
N2 = 33;     n2 = 0:N2;  % Ordnung; Indizes Einheitspulsantwort 
b2 = fir1(N2, fr, hamming(N2+1)); % Filter Entwurf mit fir1
figure(1);   clf;
subplot(211), stem(n1, b1);
title(['Einheitspulsantwort des FIR-Tiefpass Typ I, Ordnung N = ',...
    num2str(N1)]);  xlabel('n');   grid on;    axis tight;
xlabel('n');   grid on;    axis tight;
subplot(212), stem(n2, b2);
title(['Einheitspulsantwort des FIR-Tiefpass Typ II, Ordnung N = ',...
    num2str(N2)]); xlabel('n');   grid on;    axis tight;
xlabel('n');   grid on;    axis tight;
% ------ Frequenzgang ber freqz
nfft = 512;       % nfft >> N1, N2
[H1, w1] = freqz(b1,1,nfft);
[H2, w2] = freqz(b2,1,nfft);

figure(2);    clf;
subplot(221), plot(w1/(2*pi), 20*log10(abs(H1)));
title('Amplitudengang des FIR-Filters Typ I');
xlabel('f/fs');    grid on;
subplot(223), plot(w1/(2*pi), unwrap(angle(H1)));
title('Phasengang des FIR-Filters Typ I');
xlabel('f/fs');    grid on;

subplot(222), plot(w2/(2*pi), 20*log10(abs(H2)));
title('Amplitudengang des FIR-Filters Typ II');
xlabel('f/fs');    grid on;

subplot(224), plot(w2/(2*pi), unwrap(angle(H2)));
title('Phasengang des FIR-Filters Typ II');
xlabel('f/fs');    grid on;

