% Skript uebertragung_zustand_1.m, in dem die 
% bertragungsfunktionen aus dem Zustandsmodell
% eines Tiefpassfilters ermittelt werden.

clear;
s = tf('s');
% ------- Parameter der Schaltung
Rg = 100;                   % Widerstand der Quelle
L1 = 0.002;   C1 = 0.01e-6;  % Induktivitten und 
L2 = L1;      C2 = C1;      % Kapazitten
R2 = 500;                   % Widerstand der Last
% Matrizen des Zustandsmodells
A = [0,0,1/C1,-1/C1;0,-1/(C2*R2),0,1/C2;...
      -1/L1, 0 -Rg/L1, 0; 1/L2, -1/L2, 0 0];
B = [0,0,1/L1,0]';
C = eye(4,4);    D = zeros(4,1);
[eig_vekt, eig_werte] = eig(A);
eig_werte = diag(eig_werte),
% Definieren eines Zustands-Systems
my_system = ss(A, B, C, D);

% -------- bertragungsfunktionen
H = inv(s*eye(4,4) - A)*B,

figure(1);    clf;
bode(H);       % Vier Frequenzgnge werden dargestellt
% bode(my_system)
grid on;

% Frequenzgang fr den Ausgang uc2
f = logspace(3,7,500);    
[mag, phi] = bode(H, 2*pi*f);
% [mag, phi] = bode(my_system, 2*pi*f);

betrag = squeeze(mag(2,1,:));        % Amplitudengang fr uc2
phase = squeeze(phi(2,1,:));         % Phasengang fr uc2

figure(2);    clf;
subplot(211), semilogx(f, 20*log10(betrag));
title('Amplitudengang fr uc2');
xlabel('Hz');     ylabel('dB');     grid on;
subplot(212), semilogx(f, phase);
title('Phasengang fr uc2');
xlabel('Hz');     ylabel('Grad');     grid on;

figure(3);    clf;
impulse(H);
%impulse(my_system);

figure(4);    clf;
step(H);
%step(my_system);

% -------- Koeffizienten der bertragungsfunktionen mit ss2tf
[b, a] = ss2tf(A, B, C, D);
b,
a,

