% Skript uebertragung_elektrisch_1.m, in dem die
% bertragungsfunktion einer elektrischen Schaltung
% ermittelt wird

clear;
% -------- Parameter der Schaltung
Rg = 100;                   % Widerstand der Quelle
L1 = 0.002;   C1 = 0.01e-6;  % Induktivitten und 
L2 = L1;      C2 = C1;      % Kapazitten
R2 = 500;                   % Widerstand der Last
f0 = sqrt(1/(L1*C1))/(2*pi);       % Resonanzfrequenz
% -------- Definition des Objekts tf (Transfer-Function)
s = tf('s');                % Variable der Laplace-Tr.
Ua = 1;                     % Ausgangspannung
IL2 = Ua/R2 + Ua*(s*C2);
Uc1 = IL2*(s*L2) + Ua;
IL1 = Uc1*(s*C1) + IL2;
Ug = IL1*(Rg + s*L1) + Uc1; % Eingangsspannung
H = Ua/Ug,                  % bertragungsfunktion 
get(H),
b = H.num{:};   a = H.den{:}; 
% --------- Frequenzbereich fr die Darstellung
fmin = f0/100;       fmax = f0*100;
p1 = round(log10(fmin));    p2 = round(log10(fmax));
f = logspace(p1,p2, 500);   w = 2*pi*f;
Hn = freqs(b,a, w);       % Komplexer Frequenzgang

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(Hn)));
title('Betrag der bertragungsfunktion (Amplitudengang)');
xlabel('Hz');      ylabel('dB');      grid on;
subplot(212), semilogx(f, unwrap(angle(Hn))*180/pi);
title('Winkel der bertragungsfunktion (Phasengang)');
xlabel('Hz');      ylabel('Grad');      grid on;

figure(2);    clf;
Tfinal = 0.2e-3;
[h,timp] = impulse(H,Tfinal);   [sp,tstep] = step(H,Tfinal);
subplot(211), plot(timp, h);
title('Impulsantwort');    grid on;   axis tight;
subplot(212), plot(tstep, sp);
title('Sprungantwort');    grid on;   axis tight;

% -------- Frequenzgang mit Bode
[mag, phi] = bode(H,w);  % mag = Betrag; phi = Grad; w = rad/s
figure(3);     clf;
subplot(211), semilogx(f, 20*log10(squeeze(mag)));
title('Betrag der bertragungsfunktion (Amplitudengang)');
xlabel('Hz');      ylabel('dB');      grid on;
subplot(212), semilogx(f, squeeze(phi));
title('Winkel der bertragungsfunktion (Phasengang)');
xlabel('Hz');      ylabel('Grad');      grid on;
