% Skript impulsantwort_1.m, in dem exemplarisch die
% Einheitspulsantwort eines digitalen Chebxshev-IIR-
% Filters mit der Funktion filter ermittelt wird

clear;
% ------- Entwerfen des digitalen IIR-Filters
nord = 6;            % Ordnung des Filters
fp = 0.1*2;          % Relative Durchlassfrequenz
delta_p = 1;         % Welligkeit im Durchlassbereich
delta_s = 60;        % Dmpfung im Sperrbereich
%[b,a] = cheby1(nord,delta_p,fp);    % Ohne 's' das fr analoge Filter ist
[b,a] = ellip(nord,delta_p,delta_s,fp);
% ------- Impulsantwort mit filter-Funktion
nt = 30;
x = [1, zeros(1,nt-1)];    % Einheitspuls
h = filter(b,a,x);         % Einheitspulsantwort

figure(1);    clf;
subplot(211), stem(0:nt-1, x);
La = axis;     axis([-1, La(2), La(3:4)]);
title('Einheitspuls als Anregung');
xlabel('n');    grid on;
subplot(212), stem(0:nt-1, h);
La = axis;     axis([-1, La(2), La(3:4)]);
title('Einheitspulsantwort');
xlabel('n');    grid on;
% Frequenzgang des IIR-Tiefpassfilters
figure(2);    clf
nfft = 512;
[H, w] = freqz(b, a, nfft,'whole');  % Frequenzgang mit der Funktion freqz

%H = fft(b, nfft)./fft(a, nfft);      % Frequenzgang mit der FFT
%w = 2*pi*(0:nfft-1)/nfft;

subplot(211),  plot(w/(2*pi), 20*log10(abs(H)));
title('Amplitudengang des IIR-Tiefpassfilters');
xlabel('Relative Frequenz \omega/\omega_s oder f/f_s');
ylabel('dB');      grid on;

subplot(212),  plot(w/(2*pi), unwrap(angle(H))*180/pi);
title('Phasengang des IIR-Tiefpassfilters');
xlabel('Relative Frequenz \omega/\omega_s oder f/f_s');
ylabel('Grad');      grid on;




