% Skript impuls_antwort_2.m, in dem die bertragungsfunktion 
% durch einen Stoss identifiziert wird
% Arbeitet mit Modell impuls_antwort2.slx und fixe Schrittweite

clear;
% -------- Parameter der Schaltung
R = 50;          L = 0.01;      C = 0.1e-6;
f0 = sqrt(1/(L*C))/(2*pi);   % Resonantfrequenz
Ts = 1e-5;
% -------- Aufruf der Simulation mit Modell impuls_antwort2.slx
nfft = 256; 
Tsim = Ts*nfft-Ts;
options = simset('Solver','ode4','FixedStep',Ts);
sim('impuls_antwort2', [0, Tsim], options);
uc = simout.data(:,1);
i =  simout.data(:,2);
t = simout.time;
uc_puls = simout1.data(:,1);
i_puls =  simout1.data(:,2);

figure(1);     clf;
subplot(211), plot(t, uc);
title(['Impulsantwort fr die Spannung des Kondensators']);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, i);
title(['Impulsantwort fr die Strom']);
xlabel('Zeit in s');        grid on;

figure(2);     clf;
subplot(211), plot(t, uc);
title(['Angenherte Impulsantwort fr Spannung uc']);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, i);
title(['Angenherte Impulsantwort fr Strom i']);
xlabel('Zeit in s');        grid on;

% -------- Komplexer Frequenzgang (bertragungsfunktion)
% Annherung der FT der Impulsantwort
hi = uc_puls;      % oder h = uc;
Hi = Ts*fft(hi);      nh = length(Hi);  %FT Annherung
% Korrekte bertragungsfunktion
b = 1;     a = [L*C, R*C, 1];
[H,w] = freqs(b, a, (0:nfft-1)*2*pi/(nfft*Ts));

figure(3);     clf;
subplot(211), plot(w/(2*pi),abs(H),(0:nh-1)/(Ts*nh),abs(Hi));
title('Amplitudengang und Betrag der FFT*Ts der Impulsantwort');
xlabel('Hz');     grid on;     La = axis;
axis([0, 1/Ts, -1, La(4)]);
subplot(212), plot(w/(2*pi),angle(H),(0:nh-1)/(Ts*nh),angle(Hi));
title('Phasengang und Winkel der FFT der Impulsantwort');
xlabel('Hz');     grid on;     La = axis;
axis([0, 1/Ts, La(3:4)]);



