% Skript impuls_antw_zustand_1.m, in dem die Impulsantworten
% eines mechanischen Systems ermittelt werden
% Arbeitet mit Modell impuls_antw_zustand1.slx

clear;
% -------- Parameter des Feder-Masse-System
m2 = 5;      k2 = 10;           c2 = 0.3;
% Optimale Tilgerparameter nach Hartog
m1 = 2;      mu = m1/m2;        k1 = mu*k2/((1+mu)^2);
w1 = sqrt(k1/m1);               c1 = 2*w1*m1*sqrt(3*mu/(8*(1+mu)^3));
% Ohne Tilger
% m1 = 2;      k1 = 0;            c1 = 0; 
% -------- Zustandsmodell
A = [-c1/m1, -k1/m1, c1/m1, k1/m1;
    1 0 0 0;
    c1/m2, k1/m2, -(c1+c2)/m2 -(k1+k2)/m2;
    0 0 1 0];
B = [0, 0, 1/m2, 0]'; 
C = [0 1 0 0;0 0 0 1];  % Ausgangsvariablen y1, y2
D = zeros(2,1);
my_system = ss(A,B,C,D);

% -------- Aufruf des Modells
Tsim = 50;
options = simset('Solver','ode45','MaxStep',0.1);
sim('impuls_antw_zustand1',[0,Tsim],options);
y1 = simout.data(:,1);        % Lage Masse 1
y2 = simout.data(:,2);        % Lage Masse 2
t = simout.time;

figure(1);   clf;
subplot(211), plot(t, y1);
title('Impulsantwort fr die Lage der Masse 1');
xlabel('s');      grid on;
subplot(212), plot(t, y2);
title('Impulsantwort fr die Lage der Masse 2');
xlabel('s');      grid on;

figure(2);    clf;
impulse(my_system, Tsim);
grid on;