% Skript homog_diskret_1.m in dem die homogene Lsung
% eines zeitdiskreten LTI-Systems fr zwei konjugiert
% komplexe Wurzeln untersucht wird
clear;
% ------- Konjugiert komplexes Wurzelpaar
Omega = 0.7*pi/4;       % Winkel der Wurzeln
z1 = 0.9*exp(j*Omega);  % Wurzel der charakt. Gl. 
z2 = conj(z1);  
abs([z1,z2])            % Liegen sie im Einheitskreis ?
a = poly([z1,z2]);      % Charakteristische Gl.
% ------- Lsung mit Hilfe der Differenzengleichung
nyh = 50;               % Lnge der Lsung
yh = zeros(1,nyh);
yh(1) = 0.5;      % y(n-2)
yh(2) = 1;        % y(n-1)
for k = 3:nyh
    yh(k) = (-a(2)*yh(k-1) - a(3)*yh(k-2))/a(1);
end;
figure(1);   clf;
stem(0:nyh-1, yh);
   hold on
plot(0:nyh-1, yh);
   hold off;
   title('Homogene Lsung fr ein konjugiert komplexes Wurzelpaar')
   xlabel('n');    grid on;

np = 2*pi/Omega   % Mittlere Periode der Hlle


    