% Skript freqgang_1.m, in dem exemplarisch der
% Frequenzgang eines digitalen Chebxshev-IIR-
% Filters mit der Funktion freqz und mit Hilfe der
% FFT ermittelt wird

clear;
% ------- Entwerfen des digitalen IIR-Filters
nord = 6;            % Ordnung des Filters
fp = 0.1*2;          % Relative Durchlassfrequenz
delta_p = 1;         % Welligkeit im Durchlassbereich
delta_s = 60;        % Dmpfung im Sperrbereich
%[b,a] = cheby1(nord,delta_p,fp);    % Ohne 's' das fr analoge Filter ist
[b,a] = ellip(nord,delta_p,delta_s,fp);
%[b,a] = butter(nord, fp);
% ------- Frequenzgang des IIR-Tiefpassfilters
figure(1);    clf
nfft = 512;
freqz(b, a, nfft,'whole');  % Frequenzgang mit der Funktion freqz

figure(2);    clf
Hz = fft(b, nfft);       Hn = fft(a, nfft);
H = Hz./Hn;      % Frequenzgang mit der FFT (Elementweise Teilung)
w = (0:nfft-1)/nfft;
subplot(211),  plot(w, 20*log10(abs(H)));
title('Amplitudengang des IIR-Tiefpassfilters');
xlabel('Relative Frequenz \omega/\omega_s oder f/f_s');
ylabel('dB');      grid on;

subplot(212),  plot(w, unwrap(angle(H))*180/pi);
title('Phasengang des IIR-Tiefpassfilters');
xlabel('Relative Frequenz \omega/\omega_s oder f/f_s');
ylabel('Grad');    grid on;

figure(3);    clf;
subplot(211),  plot((-nfft/2:nfft/2-1)/nfft,...
    fftshift(20*log10(abs(H))));
title('Amplitudengang des IIR-Tiefpassfilters');
xlabel('Relative Frequenz \omega/\omega_s oder f/f_s');
ylabel('dB');      grid on;

subplot(212),  plot((-nfft/2:nfft/2-1)/nfft, ...
    unwrap(fftshift(angle(H)))*180/pi);
title('Phasengang des IIR-Tiefpassfilters');
xlabel('Relative Frequenz \omega/\omega_s oder f/f_s');
ylabel('Grad');    grid on;



