% Skript einseitig_1.m in dem das Spektrum eines 
% einseitigen Signals untersucht wird

clear;
% ------ Einfaches einseitiges Signals
N = 1000;
fsig = 250;      Tsig = 1/fsig;
ft = 1000;       Tt  = 1/ft;
ampl = 2;        phi = pi/3;
dt = Tt/10;
t = 0:dt:(N-1)*dt;
xr = ampl*sin(2*pi*fsig*t + phi);
xi = ampl*sin(2*pi*fsig*t + phi - pi/2);

x = xr - j*xi;
nx = length(x);
figure(1);    clf;
plot(t, xr, t, xi, 'r');
xlabel('s');   grid on;

% ------ Spektrum mit FFT
X = fft(x)/nx;
figure(2);    clf;
subplot(211), plot((-(nx-1)/2:(nx-1)/2)/(dt*nx), fftshift(abs(X)));
xlabel('Hz');    grid on;
subplot(212), plot((-(nx-1)/2:(nx-1)/2)/(dt*nx), fftshift(angle(X)));
xlabel('Hz');    grid on;

% ------ Amplitude-Modulation mit einseitigem Band
xti = sin(2*pi*ft*t);
xtq = cos(2*pi*ft*t);
xm = xti.*xr - xtq.*xi;

Xm = fft(xm)/nx;
figure(3);    clf;
subplot(211), plot((-(nx-1)/2:(nx-1)/2)/(dt*nx), fftshift(abs(Xm)));
xlabel('Hz');    grid on;
subplot(212), plot((-(nx-1)/2:(nx-1)/2)/(dt*nx), fftshift(angle(Xm)));
xlabel('Hz');    grid on;

figure(4);    clf;
plot(t, xm);
title('Moduliertes Signal');
xlabel('s');    grid on;
