% Skript analog_filter_5.m, in dem exemplarisch die Umwandlung
% eines Butterworth-Tiefpassprototyp in ein Bandpassfilter
% gezeigt wird.

clear;
% ------- Butterworth Prototyptiefpassfilter
nord = 6;              % Ordnung des Filters muss < 25
% Prototypfilter
[z,p,k] = buttap(nord);  % Pol- und Nullstellen bzw. Gain k
[b,a] = zp2tf(z,p,k);    % Koeffizienten der bertragungsfunktion

figure(1),    clf;
freqs(b,a); 
title('Frequenzgang des Butterworth-Tiefpassprototyps')

% ------- Umwandlung des Prototyps in ein Bandpassfilter
fp1 = 600;     fp2 = 800;       % Durchlassfrequenzen in Hz
f0 = sqrt(fp1*fp2);             % Mittenfrequenz
bf = fp2-fp1;                   % Bandbreite
[bt1,at1] = lp2bp(b, a, 2*pi*f0, 2*pi*bf);
c1= round(log10(fp1/10));   c2 = round(log10(fp2*10));
f = logspace(c1,c2,500);
H1 = freqs(bt1,at1,2*pi*f);

figure(2);      clf;
subplot(311), semilogx(f, 20*log10(abs(H1)));
title(['Amplitudengang des Butterworth-Filters fr fp1 = ',...
    num2str(fp1), ' Hz, fp2 = ',num2str(fp2),' Hz']);
xlabel('Hz');    ylabel('dB (20 log(abs(H)))');
grid on;         
La = axis;    axis([La(1:3), 10]);
subplot(312), semilogx(f, unwrap(angle(H1))*180/pi);
title(['Phasengang '])
xlabel('Hz');    ylabel('Grad');
grid on;
subplot(313), semilogx(f, 20*log10(abs(H1)));
title(['Ausschnitt fr den Amplitudengang']);
xlabel('Hz');    ylabel('dB (20 log(abs(H)))');
grid on;       La = axis;
axis([fp1*0.8,fp2*1.2 -20, 5]);  hold on;
plot([fp1*0.8,fp2*1.2], [-3,-3]);

% ------- Impulsantwort
Timp = 0.05;     ti = 0:0.0001:Timp;
my_system1 = tf(bt1, at1);
h1 = impulse(my_system1, ti);

figure(3);    clf;
plot(ti, h1);
title('Impulsantwort des Butterworth-Bandpassfilters');
xlabel('s');    grid on;






