% Skript analog_filter_2.m, in dem ein ideales analoges 
% Bandpassfilter untersucht wird

clear;
% -------- Idealer Frequenzgang eines Bandpassfilters
fd1 = 20;    fd2 = 30;                    % Durchlassfrequenzen;
df = fd1/50;
f = -2*fd2:df:2*fd2-df;         nf = length(f);
Hid = zeros(1,nf);              % Ideale bertragungsfunktion
Hid = 1*(f>=-fd2 & f<=-fd1) + 1*(f>=fd1 & f<=fd2);

figure(1);     clf;
subplot(311), plot(f, Hid);
title(['Fourier-Transformation der Impulsantwort',...
    ' eines idealen Bandpassfilters']);
xlabel('Hz');    grid on;
La = axis;    axis([La(1:2), 0, 1.2]);

% -------- Impulsantwort aus der inversen Fourier-Transformation
dt = (1/fd2)/100;
t = -0.5:dt:0.5;           nt = length(t);
hrek = zeros(1,nt);
for k = 1:nt
     hrek(k) = real(df*sum(Hid.*exp(j*2*pi*f*t(k))));
end;
subplot(312), plot(t, hrek);
title(['Impulsantwort aus der inversen',...
    ' Fourier-Transformation']);
xlabel('s');   grid on;

% -------- Fourier-Transformation aus der Impusantwort
Hrek = zeros(1,nf);
for k = 1:nf
   Hrek(k) = dt*sum(hrek.*exp(-j*2*pi*f(k)*t));
end;
subplot(313), plot(f, abs(Hrek))
title('Fourier-Transformation der begrenzten Impulsantwort')
xlabel('Hz');   grid on;

