% Skript analog_filter_1.m, in dem ein ideales, analoges 
% Tiefpassfilter untersucht wird

clear;
% -------- Idealer Frequenzgang eines Tiefpassfilters
fd = 20;                   % Durchlassfrequenz;
df = 2*fd/500;
f = -2*fd:df:2*fd-df;         nf = length(f);
Hid = zeros(1,nf);
Hid = 1*(f>=-fd & f<=fd);  % Ideale bertragungsfunktion

figure(1);     clf;
subplot(311), plot(f, Hid);
title(['Idealer Betrag der Fourier-Transformation',...
    ' eines idealen Tiefpassfilters']);
xlabel('Hz');    grid on;
La = axis;    axis([La(1:2), 0, 1.2]);
% -------- Impulsantwort aus der inversen Fourier-Transformation
dt = 0.5/nf;
t = -0.5:dt:0.5;           nt = length(t);
hrek = zeros(1,nt);
for k = 1:nt
     hrek(k) = real(df*sum(Hid.*exp(j*2*pi*f*t(k))));
end;
subplot(312), plot(t, hrek);
title(['Analytische Impulsantwort und aus der inversen',...
    ' Fourier-Transformation']);
xlabel('s');   grid on;

% Analytische Impulsantwort
hana = 2*fd*sinc(2*fd*t);
hold on;     plot(t, hana, 'r');    hold off;

% -------- Fourier-Transformation aus der Impusantwort
Hrek = zeros(1,nf);
for k = 1:nf
   Hrek(k) = dt*sum(hrek.*exp(-j*2*pi*f(k)*t));
end;
subplot(313), plot(f, abs(Hrek))
title('Fourier-Transformation aus der begrenzten Impulsantwort')
xlabel('Hz');   grid on;

