% Skript RLC_reihen_1.m, in dem eine RLC-Reihenschaltung
% mit dem Modell RLC_reihen1.slx und RLC_reihen2.slx
% untersucht wird.

clear;
% -------- Parameter der Schaltung
R = 50;          L = 0.01;      C = 0.1e-6;
ampl_ug = 2;     phi_ug = pi/3;
f_ug = 1000;    % Frequenz der Anregung
f0 = sqrt(1/(L*C))/(2*pi);   % Resonanzfrequenz
% -------- Zustandsmodell fr Zustandsvariablen 
%          Strom i, Spannung uc
Az = [-R/L, -1/L;1/C, 0];      Bz = [1/L; 0];
Cz = eye(2,2);                 Dz = 0;

% -------- Gesamte Antwort ber lsim-Funktion
fmax = max([f_ug, f0]);     Tmin = 1/fmax;
Ts = Tmin/100;              Tsim = 0.005;

uc0 = -2;                   i0 = 0;
% Anregung
t = 0:Ts:Tsim-Ts;           nt = length(t);
ug = ampl_ug*sin(2*pi*f_ug*t + phi_ug);
my_system = ss(Az, Bz, Cz, Dz);    % Zustandssystem
[y, t] = lsim(my_system, ug', t', [i0,uc0]);
i = y(:,1);      uc = y(:,2);

figure(1);     clf;
subplot(211), plot(t, uc);
title(['Spannung des Kondensators mit uc(0) = ',num2str(uc0)]);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, i);
title(['Strom der Reihenschaltung mit i(0) = ',num2str(i0)]);
xlabel('Zeit in s');        grid on;

