% Skript RLC_reihen_3.m, in dem eine RLC-Reihenschaltung
% mit dem Modell RLC_reihen3.slx untersucht wird.
% Es wird die alternative Zerlegung untersucht

clear;
% -------- Parameter der Schaltung
R = 50;          L = 0.01;      C = 0.1e-6;
ampl_ug = 2;     phi_ug = pi/3;
f_ug = 1000;    % Frequenz der Anregung
f0 = sqrt(1/(L*C))/(2*pi);    % Resonanzfrequenz
% -------- Aufruf der Simulation mit Modell RLC_reihen3.slx
uc0 = -2;      i0 = 0;
Tsim = 0.005;
options = simset('Solver','ode45','MaxStep', (1/f0)/50);
sim('RLC_reihen3', [0, Tsim], options);
uc_direkt = simout.data(:,1);
uc_zerlegung =  simout.data(:,2);
uc_anreg = simout1.data(:,1);
uc_ohne =  simout1.data(:,2);
t = simout.time;

figure(1);     clf;
subplot(211), plot(t, uc_direkt);
title(['Spannung des Kondensators ']);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, uc_zerlegung);
title(['Spannung des Kondensators aus der alternativen Zerlegung ']);
xlabel('Zeit in s');        grid on;

figure(2);     clf;
subplot(211), plot(t, uc_anreg);
title(['Spannung des Kondensators mit Anregung und',...
     ' Anfangsbedingungen null ']);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, uc_ohne);
title(['Spannung des Kondensators ohne Anregung mit',...
     ' Anfangsbedingungen']);
xlabel('Zeit in s');        grid on;



