% Skript RLC_reihen_1.m, in dem eine RLC-Reihenschaltung
% mit dem Modell RLC_reihen1.slx und RLC_reihen2.slx
% untersucht wird.

clear;
% -------- Parameter der Schaltung
R = 50;          L = 0.01;      C = 0.1e-6;
ampl_ug = 2;     phi_ug = pi/3;
f_ug = 1000;    % Frequenz der Anregung
% -------- Charakteristisches Polynom
charak_poly = [1, R/L, 1/(L*C)];
wurzeln = roots(charak_poly),
f0 = sqrt(1/(L*C))/(2*pi),          % Resonanzfrequenz
fch = abs(imag(wurzeln(1)))/(2*pi), % Eigenfrequenz
sigma = real(wurzeln(1));            % Dmpfungsfaktor
% -------- Homogene Lsung
dt = 1/(f0*100);
t = 0:dt:10/f0;
C1 = 0.1+j*0.5;     C2 = 0.1-j*0.5;
uch = C1*exp(sigma*t).*exp(j*2*pi*fch*t) + ...
      C2*exp(sigma*t).*exp(-j*2*pi*fch*t);
figure(1);        clf;
plot(t, uch);
title(['Homogene Loesung fr C1 = ',num2str(C1),';  C2 = C1*']);
xlabel('Zeit in s');   grid on;

% -------- Komplexer Frequenzgang
b = 1;     a = [L*C, R*C, 1];
[H,w] = freqs(b, a);
figure(2);     clf;
subplot(211), plot(w/(2*pi), abs(H));
title('Amplitudengang');    xlabel('Hz');
grid on;       hold on;     La = axis;
plot([f0, f0], [La(3), La(4)],'r');
hold off;
subplot(212), plot(w/(2*pi), angle(H)*180/pi);
title('Phasengang');    xlabel('Hz');   ylabel('Grad')
grid on;       hold on;     La = axis;
plot([f0, f0], [La(3), La(4)],'r');
hold off;

% Zustandsmodell fr Zustandsvariablen Strom i, Spannung uc
Az = [-R/L, -1/L;1/C, 0];      Bz = [1/L; 0];
Cz = eye(2,2);                 Dz = 0;
[eig_vektor, eig_werte] = eig(Az);

c1 = C1;     c2 = C2;
xh = c1*eig_vektor(:,1)*exp(eig_werte(1,1)*t) + ...
     c2*eig_vektor(:,2)*exp(eig_werte(2,2)*t);
figure(3);    clf;
subplot(211), plot(t, xh(1,:));
title(['Homogener Strom i fr c1 = ',num2str(C1),';  c2 = c1*']);
xlabel('Zeit in s');   grid on;
subplot(212), plot(t, xh(2,:));
title(['Homogene Spannung uc fr c1 = ',num2str(C1),';  c2 = c1*']);
xlabel('Zeit in s');   grid on;

% -------- Aufruf der Simulation mit Modell RLC_reihen1.slx
uc0 = -2;      i0 = 0;
Tsim = 0.005;
options = simset('Solver','ode45','MaxStep', (1/f0)/50);
sim('RLC_reihen1', [0, Tsim], options);
uc = simout.data(:,1);
i =  simout.data(:,2);
t = simout.time;

figure(4);     clf;
subplot(211), plot(t, uc);
title(['Spannung des Kondensators mit uc(0) = ',num2str(uc0)]);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, i);
title(['Strom der Reihenschaltung mit i(0) = ',num2str(i0)]);
xlabel('Zeit in s');        grid on;

% -------- Aufruf der Simulation mit Zustandsmodell RLC_reihen2.slx
uc0 = -2;      i0 = 0;
Tsim = 0.005;
options = simset('Solver','ode45','MaxStep', (1/f0)/50);
sim('RLC_reihen2', [0, Tsim], options);
i = x.data(:,1);
uc =  x.data(:,2);
t = x.time;

figure(5);     clf;
subplot(211), plot(t, uc);
title(['Spannung des Kondensators mit uc(0) = ',num2str(uc0)]);
xlabel('Zeit in s');        grid on;
subplot(212), plot(t, i);
title(['Strom der Reihenschaltung mit i(0) = ',num2str(i0)]);
xlabel('Zeit in s');        grid on;

