% Skript zero_padd3.m, in dem die Erweiterung mit
% Nullwerten im Zeitbereich untersucht wird. Arbeitet
% mit Modell zero_padd_3.slx
clear;
% -------- Parameter der Simulation
fs = 1000;         % Abtastfrequenz
Ts = 1/fs;         % Abtastperiode
%N = 500;          % Anzahl der Abtastwerte aus dem Signal
N = 1000;          % Anzahl der Abtastwerte aus dem Signal
%N = 2000;          % Anzahl der Abtastwerte aus dem Signal
%nfft = 1024;       % Gre der FFT (nfft - N = Anzahl der Nullwerte)
%nfft = 2048;       % Gre der FFT (nfft - N = Anzahl der Nullwerte)
nfft = 4*1024;     % Es muss nfft > N
                   % nfft muss grer als N sein
fsig1 = 100;       % Frequenz des ersten Signals
ampl1 = 1;
df = 5;            % Abstand der Frequenz des zweiten Signals
fsig2 = fsig1 + df;% Frequenz des zweiten Signals
ampl2 = 0.5;

fsig1,    fsig2,
% -------- Aufruf der Simulation
pw = sum(hamming(N).^2)/N;     % Normierungsfaktor wegen der Fensterfunktion
Tf = 50*N*Ts;
sim('zero_padd_2',[0, Tf]);
y_sig = y.signals.values(:,:,end);    % Signal ohne Nullerweiterung
Y = Y.signals.values(:,:,end);        % Betrag DFT*Ts

figure(1);    clf;
subplot(311), plot((0:length(y_sig)-1)*Ts, y_sig);
title(['Signal mit Fensterfunktion ohne Nullerweiterung N = ',num2str(N),...
    '; nfft = ',num2str(nfft),'; fs = ',num2str(fs),' Hz']);
xlabel('Zeit in s');     grid on;   axis tight;

subplot(312), stem((0:nfft-1)*fs/nfft, abs(Y));
hold on;   plot((0:nfft-1)*fs/nfft, abs(Y));   hold off;
title(['FFT^2/(N*nfft*w) mit fsig1 = ',num2str(fsig1), ...
    ' Hz; fsig2 = ',num2str(fsig2),' Hz und N = ',...
    num2str(N),' bzw. nfft = ',num2str(nfft)]);
xlabel('Frequenz in Hz');     grid on;

subplot(313), stem((0:nfft-1)*fs/nfft, abs(Y));
hold on;   plot((0:nfft-1)*fs/nfft, abs(Y));   hold off;
La = axis;     axis([fsig1-20, fsig2+20, La(3:4)]);
title(['FFT^2/(N*nfft*w) mit fsig1 = ',num2str(fsig1), ...
    ' Hz; fsig2 = ',num2str(fsig2),' Hz und N = ',...
    num2str(N),' bzw. nfft = ',num2str(nfft),' (Ausschnitt)']);
xlabel('Frequenz in Hz');     grid on;

% ------- Parseval Theorem
P_zeit = sum(y_sig.^2)/(N*pw),
P_freq1 = sum(Y),