% Skript zero_padd1.m, in dem die Erweiterung mit
% Nullwerten im Zeitbereich untersucht wird. Arbeitet
% mit Modell zero_padd_1.slx
clear;
% -------- Parameter der Simulation
fs = 1000;         % Abtastfrequenz
Ts = 1/fs;         % Abtastperiode
%N = 500;          % Anzahl der Abtastwerte aus dem Signal
%N = 1000;          % Anzahl der Abtastwerte aus dem Signal
N = 2000;          % Anzahl der Abtastwerte aus dem Signal

%nfft = 512;       % Gre der FFT (nfft - N = Anzahl der Nullwerte)
%nfft = 1024;       % Gre der FFT (nfft - N = Anzahl der Nullwerte)
%nfft = 2048;       % Gre der FFT (nfft - N = Anzahl der Nullwerte)
nfft = 2*2048;       % Gre der FFT (nfft - N = Anzahl der Nullwerte)
                   % nfft muss grer als N sein
fsig1 = 100;       % Frequenz des ersten Signals
df = 1;            % Abstand der Frequenz des zweiten Signals
fsig2 = fsig1 + df;% Frequenz des zweiten Signals
fsig1,
fsig2,
% -------- Aufruf der Simulation
Tf = 3*N*Ts;
sim('zero_padd_1',[0, Tf]);
y_sig = y1.signals.values(:,:,end);    % Signal mit Nullerweiterung
Y = y.signals.values(:,:,end);         % Betrag DFT/N

figure(1);    clf;
subplot(211), plot((0:length(y_sig)-1)*Ts, y_sig);
title(['Signal mit Nullerweiterung N = ',num2str(N),...
    '; nfft = ',num2str(nfft),'; fs = ',num2str(fs),' Hz']);
xlabel('Zeit in s');     grid on;   axis tight;

subplot(212), stem((0:nfft-1)*fs/nfft, abs(Y));
hold on;   plot((0:nfft-1)*fs/nfft, abs(Y));   hold off;
La = axis;     axis([fsig1-5, fsig1+5, La(3:4)]);
title(['FFT/nfft mit fsig1 = ',num2str(fsig1), ...
    ' Hz; fsig2 = ',num2str(fsig2),' Hz und N = ',...
    num2str(N),' bzw. nfft = ',num2str(nfft)]);
xlabel('Frequenz in Hz');     grid on;
