% Skript ton_aliasing_1.m, in dem das Aliasing eines Chirp-Signals
% mit Modell ton_aliasing1.slx untersucht wird
clear;
% -------- Parameter der Simulation
tmax = 40;          % Dauer der Simulation
fs = 10;            % Abtastfrequenz
fmax = 2*fs;        % Maximale Frequenz des Chirp-Signals;

% -------- Aufruf der Simulation
Tf = tmax;
sim('ton_aliasing1', [0,Tf]);
t = y.time;         % Simulationsschritte
xabt = y.data(:,1); % Abgetastetes Chirp-Signal
x = y.data(:,2);    % kontinuierliches Chirp-Signal

figure(1);    clf;
subplot(411), plot(t(1:2000),    x(1:2000));
title('Chirp-Signal');   grid on;
subplot(412), plot(t(2001:4000), x(2001:4000));   grid on;
subplot(413), plot(t(4001:6000), x(4001:6000));   grid on;
subplot(414), plot(t(6001:8001), x(6001:8001));   grid on;
xlabel('Zeit in s');
figure(2);    clf;
subplot(411), plot(t(1:2000),    xabt(1:2000));
title('Abgetastetes Chirp-Signal');   grid on;
subplot(412), plot(t(2001:4000), xabt(2001:4000));   grid on;
subplot(413), plot(t(4001:6000), xabt(4001:6000));   grid on;
subplot(414), plot(t(6001:8001), xabt(6001:8001));   grid on;
xlabel('Zeit in s');
