% Skript spektr_pulse_1.m, in dem die Aliased-Komponenten
% fr rechteckigen Signal untersucht werden
% Arbeitet mit Modell spektr_pulse1.slx
clear;

% ------- Parameter der Simulation
N = 2048;        % Anzahl Abtastwerte im Untersuchungsintervall
fs = 50000;      % Abtastfrequenz in Hz
f0 = 1010;       % Frequenz des rechteckigen Signals
tast = 50;       % Tatsverhltnis in Prozent

% ------- Aufruf der Simulation
Tfinal = 1;
wp = sum(hanning(N).^2);         % Leistung der Fensterwerte
sim('spektr_pulse1',[0,Tfinal]);
P = Y(:,:,end);

figure(1);    clf;
plot((0:N-1)*fs/N, 10*log10(P));
title(['Spektrale Leistung f0 = ', num2str(f0),' Hz, fs = ',...
    num2str(fs),' Hz, N = ',num2str(N)]);
xlabel('Hz');     ylabel('Leistung in dB');    grid on;
La = axis;    axis([La(1:2), -70, La(4)]);
% ------- Anzahl Perioden im Untersuchungsintervall
T0 = 1/f0;        % Periode
np = N*f0/fs,

