function [v1, v2, v3] = schar_1
% Funktion schar_1.m in der drei Zufallsprozesse
% mit je vier Realisierungen erzeugt werden:
% 1) Nicht stationre und nicht ergodische 
% 2) Stationre und nicht ergodische
% 3) Stationre und ergodische

clear;
rand('seed', 12379);        % Startwerte fr 
randn('seed', 967952);       % die Zufallsgeneratoren

nd = 200;
%#######################
v1 = schar1(4,nd);  % 1) Nicht stationre und nicht ergodische

figure(1);    clf;
subplot(411), stem(0:nd-1, v1(1,:));
title('Nicht  stationre  und  nicht  ergodische Schar');
grid on;
subplot(412), stem(0:nd-1, v1(2,:));
grid on;
subplot(413), stem(0:nd-1, v1(3,:));
grid on;
subplot(414), stem(0:nd-1, v1(4,:));
xlabel(' Index  k');   grid on;
%#######################
v2 = schar2(4,nd);  % 2) Stationre und nicht ergodische
v2_mean = mean(v2,2);

figure(2);    clf;
subplot(411), stem(0:nd-1, v2(1,:));
title('Stationre  und  nicht ergodische Schar');
hold on
plot([0, nd-1], [v2_mean(1), v2_mean(1)],'r');
hold off;       grid on;      
subplot(412), stem(0:nd-1, v2(2,:));
hold on
plot([0, nd-1], [v2_mean(2), v2_mean(2)],'r');
hold off;       grid on;
subplot(413), stem(0:nd-1, v2(3,:));
hold on
plot([0, nd-1], [v2_mean(3), v2_mean(3)],'r');
hold off;       grid on;
subplot(414), stem(0:nd-1, v2(4,:));
hold on
plot([0, nd-1], [v2_mean(4), v2_mean(4)],'r');
hold off;       xlabel(' Index  k');   grid on;

%#######################
v3 = schar3(4,nd);   % 3) Stationre und ergodische
v3_mean = mean(v3,2);

figure(3);    clf;
subplot(411), stem(0:nd-1, v3(1,:));
title('Stationre  und  ergodische Schar');
hold on
plot([0, nd-1], [v3_mean(1), v3_mean(1)],'r');
hold off;       grid on;

subplot(412), stem(0:nd-1, v3(2,:));
hold on
plot([0, nd-1], [v3_mean(2), v3_mean(2)],'r');
hold off;       grid on;

subplot(413), stem(0:nd-1, v3(3,:));
hold on
plot([0, nd-1], [v3_mean(3), v3_mean(3)],'r');
hold off;       grid on;

subplot(414), stem(0:nd-1, v3(4,:));
hold on
plot([0, nd-1], [v3_mean(4), v3_mean(4)],'r');
hold off;       xlabel(' Index  k');   grid on;

%###################################
function v = schar1(m,n);
a = 0.1;
b = 10;
mc = ones(m,1)*b*sin((1:n)*pi/n);
ac = a*ones(m,1)*[1:n];
v = randn(m,n).*mc + ac;
%###################################
function v = schar2(m,n);
ar = 10*(rand(m,1)-0.5)*ones(1,n);
mr = 2*rand(m,1)*ones(1,n);
v = randn(m,n).*mr + ar;
%###################################
function v = schar3(m,n);
a= 5;
m_s = 3;
v = randn(m,n)*m_s + a;



