% Skript normal_1.m, in dem eine normal verteilte Sequenz
% untersucht wird. Es wird die geschtzte Wahrscheinlichkeits-
% dichte ermittelt

clear;
% ------- Sequenz
n = 1000;        % Anzahl der Werte in der Probe 
mx = 2;          % Mittelwert
varianz = 1;     % Standardabweichung
x = sqrt(varianz)*randn(1,n) + mx;      % Sequenz (Probe)
% ------- Hufigkeiten
ni = 20;         % Anzahl der Intervalle
[Hae, i] = hist(x, ni);   % Hufigkeiten in ni Intervallen
di = i(2) -i(1);          % Gre der Intervalle
pdf_gs = (Hae/n)/di;        % Geschtzte PDF
% ------- Die ideale PDF
dx = 0.1;
xid = mx-4*sqrt(varianz):dx:mx+4*sqrt(varianz); % Bereich fr die Ideale PDF
pxid = (1/sqrt(varianz*2*pi))*exp(-(xid - mx).^2/(2*varianz));

figure(1);    clf;
subplot(211), plot(0:n-1, x);
title(['Normal verteilte Sequenz (m = ',num2str(mx),'; \sigma = ',...
    num2str(sqrt(varianz)),' )']);
xlabel(' Index der Werte');   grid on;
subplot(212), bar(i, pdf_gs);
hold on;      plot(xid, pxid);     hold off;
title('Geschtzte und ideale PDF');   grid on;

